/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pushingpixels.substance.api.combo.WidestComboPopupPrototype;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;
import test.check.ControllablePanel;
import test.check.MyListCellRenderer;
import test.check.MySubstanceListCellRenderer;
import test.check.ScrollablePanel;

public class ListPanel
extends ControllablePanel {
    private JList list;
    private JButton bUp;
    private JButton bDown;
    private JButton bDelete;
    private Color oldBackColor;

    public ListPanel() {
        this.setLayout(new BorderLayout());
        this.list = new JList(new MoveableListModel(100));
        this.list.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return true;
            }

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                return true;
            }

            @Override
            public boolean importData(JComponent comp, Transferable t) {
                return false;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                return false;
            }
        });
        this.list.setDropMode(DropMode.ON);
        final JScrollPane jsp = new JScrollPane(this.list);
        this.add((Component)jsp, "Center");
        FormLayout lm = new FormLayout("right:pref, 4dlu, fill:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm, new ScrollablePanel());
        builder.appendSeparator("General");
        final JCheckBox isEnabled = new JCheckBox("is enabled");
        isEnabled.setSelected(this.list.isEnabled());
        isEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPanel.this.list.setEnabled(isEnabled.isSelected());
            }
        });
        builder.append("Enabled", (Component)isEnabled);
        final JSlider rowCountSlider = new JSlider(10, 1000, this.list.getModel().getSize());
        rowCountSlider.setPaintLabels(false);
        rowCountSlider.setPaintTicks(false);
        rowCountSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (rowCountSlider.getValueIsAdjusting()) {
                    return;
                }
                ListPanel.this.list.setModel(new MoveableListModel(rowCountSlider.getValue()));
            }
        });
        builder.append("Row count", (Component)rowCountSlider);
        final JCheckBox watermarkBleed = new JCheckBox("watermark bleed");
        watermarkBleed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPanel.this.list.putClientProperty("substancelaf.watermark.visible", watermarkBleed.isSelected());
                jsp.putClientProperty("substancelaf.watermark.visible", watermarkBleed.isSelected());
                ListPanel.this.list.repaint();
            }
        });
        builder.append("Watermark", (Component)watermarkBleed);
        this.bUp = new JButton("Move selected up");
        this.bUp.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.bDown = new JButton("Move selected down");
        this.bDown.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.bDelete = new JButton("Delete selected");
        this.bDelete.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        builder.append("Actions", (Component)this.bUp);
        builder.append("", (Component)this.bDown);
        builder.append("", (Component)this.bDelete);
        this.bUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int si = ListPanel.this.list.getSelectedIndex();
                MoveableListModel mlm = (MoveableListModel)ListPanel.this.list.getModel();
                mlm.moveUp(si);
                ListPanel.this.list.setSelectedIndex(si - 1);
            }
        });
        this.bDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int si = ListPanel.this.list.getSelectedIndex();
                MoveableListModel mlm = (MoveableListModel)ListPanel.this.list.getModel();
                mlm.moveDown(si);
                ListPanel.this.list.setSelectedIndex(si + 1);
            }
        });
        this.bDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MoveableListModel mlm = (MoveableListModel)ListPanel.this.list.getModel();
                int i = ListPanel.this.list.getMaxSelectionIndex();
                while (i >= ListPanel.this.list.getMinSelectionIndex()) {
                    if (ListPanel.this.list.isSelectedIndex(i)) {
                        mlm.delete(i);
                    }
                    --i;
                }
                ListPanel.this.list.clearSelection();
            }
        });
        this.synchronize();
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ListPanel.this.synchronize();
                    }
                });
            }
        });
        final JComboBox<Object> selectionModelCb = new JComboBox<Object>(new Object[]{"single", "single interval", "multiple interval"});
        selectionModelCb.setSelectedIndex(0);
        this.list.setSelectionMode(0);
        selectionModelCb.putClientProperty("substancelaf.comboPopupPrototype", new WidestComboPopupPrototype());
        selectionModelCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String selected = (String)selectionModelCb.getSelectedItem();
                        if ("single".equals(selected)) {
                            ListPanel.this.list.setSelectionMode(0);
                        }
                        if ("single interval".equals(selected)) {
                            ListPanel.this.list.setSelectionMode(1);
                        }
                        if ("multiple interval".equals(selected)) {
                            ListPanel.this.list.setSelectionMode(2);
                        }
                    }
                });
            }
        });
        builder.append("Selection", selectionModelCb);
        final JCheckBox customBackgroundCb = new JCheckBox("Has pink background");
        customBackgroundCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (customBackgroundCb.isSelected()) {
                    ListPanel.this.oldBackColor = ListPanel.this.list.getBackground();
                    ListPanel.this.list.setBackground(new Color(255, 128, 128));
                } else {
                    ListPanel.this.list.setBackground(ListPanel.this.oldBackColor);
                }
            }
        });
        builder.append("Background", (Component)customBackgroundCb);
        builder.appendSeparator("Renderer");
        ButtonGroup listRendererGroup = new ButtonGroup();
        final JRadioButton substanceRenderer = new JRadioButton("Substance");
        substanceRenderer.setSelected(true);
        substanceRenderer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (substanceRenderer.isSelected()) {
                    ListPanel.this.list.setCellRenderer(new SubstanceDefaultListCellRenderer());
                }
            }
        });
        final JRadioButton coreDefaultRenderer = new JRadioButton("Default core");
        coreDefaultRenderer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (coreDefaultRenderer.isSelected()) {
                    ListPanel.this.list.setCellRenderer(new DefaultListCellRenderer());
                }
            }
        });
        final JRadioButton customRenderer = new JRadioButton("Custom");
        customRenderer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (customRenderer.isSelected()) {
                    ListPanel.this.list.setCellRenderer(new MyListCellRenderer());
                }
            }
        });
        final JRadioButton customSubstanceRenderer = new JRadioButton("Custom Substance");
        customSubstanceRenderer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (customSubstanceRenderer.isSelected()) {
                    ListPanel.this.list.setCellRenderer(new MySubstanceListCellRenderer());
                }
            }
        });
        listRendererGroup.add(substanceRenderer);
        listRendererGroup.add(coreDefaultRenderer);
        listRendererGroup.add(customRenderer);
        listRendererGroup.add(customSubstanceRenderer);
        builder.append("Select type", (Component)substanceRenderer);
        builder.append("", (Component)coreDefaultRenderer);
        builder.append("", (Component)customRenderer);
        builder.append("", (Component)customSubstanceRenderer);
        this.controlPanel = builder.getPanel();
    }

    public void synchronize() {
        int sc = this.list.getSelectedIndices().length;
        if (sc != 1) {
            this.bUp.setEnabled(false);
            this.bDown.setEnabled(false);
            return;
        }
        this.bDelete.setEnabled(sc > 0);
        int si = this.list.getSelectedIndex();
        this.bUp.setEnabled(si > 0);
        this.bDown.setEnabled(si < this.list.getModel().getSize() - 1);
    }

    private static class MoveableListModel
    extends AbstractListModel {
        protected List<String> model = new ArrayList<String>();

        public MoveableListModel(int modelSize) {
            int i = 0;
            while (i < modelSize) {
                this.model.add("element " + i);
                ++i;
            }
        }

        @Override
        public Object getElementAt(int index) {
            return this.model.get(index);
        }

        @Override
        public int getSize() {
            return this.model.size();
        }

        public void moveUp(int index) {
            String entry = this.model.get(index);
            this.model.set(index, this.model.get(index - 1));
            this.model.set(index - 1, entry);
            this.fireContentsChanged(this, index - 1, index);
        }

        public void moveDown(int index) {
            String entry = this.model.get(index);
            this.model.set(index, this.model.get(index + 1));
            this.model.set(index + 1, entry);
            this.fireContentsChanged(this, index, index + 1);
        }

        public void delete(int index) {
            this.model.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }

        public void move(int fromIndex, int toIndex) {
            String from = this.model.remove(fromIndex);
            this.model.add(toIndex, from);
            this.fireContentsChanged(this, fromIndex, toIndex);
        }
    }
}

