/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import test.Check;
import test.check.SampleMenuFactory;

public class MousePopupListener
extends MouseAdapter {
    private JComponent owner;

    public MousePopupListener(JComponent owner) {
        this.owner = owner;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.checkPopup(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.checkPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkPopup(e);
    }

    void checkPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPopupMenu popup = new JPopupMenu();
            int mcount = 0;
            for (LinkedList linkedList : SampleMenuFactory.getTestMenuItems()) {
                if (mcount > 0) {
                    if (mcount % 2 == 0) {
                        popup.addSeparator();
                    } else {
                        popup.add(new JSeparator());
                    }
                }
                for (JMenuItem menuItem : linkedList) {
                    popup.add(menuItem);
                }
                ++mcount;
            }
            popup.addPopupMenuListener(new PopupPrintListener());
            popup.show(this.owner, e.getX(), e.getY());
        }
    }

    protected static class PopupPrintListener
    implements PopupMenuListener {
        protected PopupPrintListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            Check.out("Popup menu will be visible!");
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            Check.out("Popup menu will be invisible!");
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            Check.out("Popup menu is hidden!");
        }
    }
}

