/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.fonts.FontPolicy;
import org.pushingpixels.substance.api.fonts.FontSet;

public class MyLocaleChangeListener
implements ActionListener {
    private String langCode;
    private String countryCode;
    private JFrame frame;

    public MyLocaleChangeListener(String langCode, String countryCode, JFrame frame) {
        this.langCode = langCode;
        this.countryCode = countryCode;
        this.frame = frame;
    }

    void setLocale(Component component, Locale locale) {
        component.setLocale(locale);
        if (component instanceof Container) {
            Container cont = (Container)component;
            int i = 0;
            while (i < cont.getComponentCount()) {
                this.setLocale(cont.getComponent(i), locale);
                ++i;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LookAndFeel currLaf = UIManager.getLookAndFeel();
                Locale newLocale = new Locale(MyLocaleChangeListener.this.langCode, MyLocaleChangeListener.this.countryCode);
                Locale.setDefault(newLocale);
                MyLocaleChangeListener.this.frame.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
                if (currLaf instanceof SubstanceLookAndFeel) {
                    SubstanceLookAndFeel.resetLabelBundle();
                    if ("CN".equals(MyLocaleChangeListener.this.countryCode)) {
                        final FontSet currFontSet = SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null);
                        SubstanceLookAndFeel.setFontPolicy(new FontPolicy(){

                            @Override
                            public FontSet getFontSet(String lafName, UIDefaults table) {
                                return new DialogFontSet(currFontSet);
                            }
                        });
                    } else {
                        SubstanceLookAndFeel.setFontPolicy(null);
                    }
                }
                try {
                    UIManager.setLookAndFeel(currLaf.getClass().getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SwingUtilities.updateComponentTreeUI(MyLocaleChangeListener.this.frame);
            }
        });
    }

    private static class DialogFontSet
    implements FontSet {
        private FontSet delegate;

        public DialogFontSet(FontSet delegate) {
            this.delegate = delegate;
        }

        private FontUIResource getWrappedFont(FontUIResource systemFont) {
            return new FontUIResource("Dialog", systemFont.getStyle(), systemFont.getSize());
        }

        @Override
        public FontUIResource getControlFont() {
            return this.getWrappedFont(this.delegate.getControlFont());
        }

        @Override
        public FontUIResource getMenuFont() {
            return this.getWrappedFont(this.delegate.getMenuFont());
        }

        @Override
        public FontUIResource getMessageFont() {
            return this.getWrappedFont(this.delegate.getMessageFont());
        }

        @Override
        public FontUIResource getSmallFont() {
            return this.getWrappedFont(this.delegate.getSmallFont());
        }

        @Override
        public FontUIResource getTitleFont() {
            return this.getWrappedFont(this.delegate.getTitleFont());
        }

        @Override
        public FontUIResource getWindowTitleFont() {
            return this.getWrappedFont(this.delegate.getWindowTitleFont());
        }
    }
}

