/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;

public class MySubstanceListCellRenderer
extends SubstanceDefaultListCellRenderer {
    public MySubstanceListCellRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component result = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        result.setForeground(list.getForeground());
        int comp = 156 + 10 * (index % 9);
        int blue = 255 - (255 - comp) / 2;
        result.setBackground(new Color(comp, comp, blue));
        if (isSelected) {
            result.setBackground(list.getSelectionBackground());
        }
        if (index % 5 == 0) {
            result.setEnabled(false);
            ComponentState state = isSelected ? ComponentState.DISABLED_SELECTED : ComponentState.DISABLED_UNSELECTED;
            result.setForeground(SubstanceLookAndFeel.getCurrentSkin(list).getColorScheme(list, state).getForegroundColor());
            result.setBackground(new Color(255, 196, 196));
            ((JLabel)result).setText(value + " [disabled by renderer]");
        }
        return this;
    }
}

