/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.RunOnUIThread;
import org.pushingpixels.trident.callback.TimelineCallbackAdapter;
import test.check.ScrollablePanel;

public class ProgressBarPanel
extends JPanel {
    private JButton startButton;
    private JButton stopButton;

    public ProgressBarPanel() {
        this.setLayout(new BorderLayout());
        ScrollablePanel bars = new ScrollablePanel();
        GridLayout gLayout = new GridLayout(1, 2);
        bars.setLayout(gLayout);
        FormLayout horizontalLm = new FormLayout("left:pref:grow", "");
        DefaultFormBuilder horizontalBuilder = new DefaultFormBuilder(horizontalLm);
        horizontalBuilder.setDefaultDialogBorder();
        JProgressBar determinateEnHor = new JProgressBar(0, 0, 100);
        determinateEnHor.setIndeterminate(false);
        horizontalBuilder.appendSeparator("Determinate enabled");
        horizontalBuilder.append(determinateEnHor);
        JProgressBar determinateEnHorStr = new JProgressBar(0, 0, 100);
        determinateEnHorStr.setIndeterminate(false);
        determinateEnHorStr.setStringPainted(true);
        horizontalBuilder.appendSeparator("Determinate enabled + string");
        horizontalBuilder.append(determinateEnHorStr);
        JProgressBar indeterminateEnHor = new JProgressBar(0, 0, 100);
        indeterminateEnHor.setIndeterminate(true);
        indeterminateEnHor.setStringPainted(true);
        indeterminateEnHor.setString("In progress");
        horizontalBuilder.appendSeparator("Indeterminate enabled + string");
        horizontalBuilder.append(indeterminateEnHor);
        JProgressBar determinateDisHor = new JProgressBar(0, 0, 100);
        determinateDisHor.setIndeterminate(false);
        determinateDisHor.setEnabled(false);
        horizontalBuilder.appendSeparator("Determinate disabled");
        horizontalBuilder.append(determinateDisHor);
        JProgressBar determinateDisHorStr = new JProgressBar(0, 0, 100);
        determinateDisHorStr.setIndeterminate(false);
        determinateDisHorStr.setEnabled(false);
        determinateDisHorStr.setStringPainted(true);
        horizontalBuilder.appendSeparator("Determinate disabled + string");
        horizontalBuilder.append(determinateDisHorStr);
        JProgressBar indeterminateDisHor = new JProgressBar(0, 0, 100);
        indeterminateDisHor.setIndeterminate(true);
        indeterminateDisHor.setEnabled(false);
        horizontalBuilder.appendSeparator("Indeterminate disabled");
        horizontalBuilder.append(indeterminateDisHor);
        bars.add(horizontalBuilder.getPanel());
        FormLayout verticalLm = new FormLayout("center:pref:grow, 4dlu, center:pref:grow, 4dlu, center:pref:grow, 4dlu, center:pref:grow, 4dlu, center:pref:grow", "");
        DefaultFormBuilder verticalBuilder = new DefaultFormBuilder(verticalLm);
        verticalBuilder.setDefaultDialogBorder();
        verticalBuilder.append("Enabled");
        verticalBuilder.append("RTL");
        verticalBuilder.append("Indeterm");
        verticalBuilder.append("Disabled");
        verticalBuilder.append("Dis indet");
        JProgressBar determinateEnVer = new JProgressBar(1, 0, 100);
        determinateEnVer.setIndeterminate(false);
        determinateEnVer.setStringPainted(true);
        verticalBuilder.append(determinateEnVer);
        JProgressBar determinateEnVerRTL = new JProgressBar(1, 0, 100);
        determinateEnVerRTL.setIndeterminate(false);
        determinateEnVerRTL.setStringPainted(true);
        determinateEnVerRTL.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        verticalBuilder.append(determinateEnVerRTL);
        JProgressBar indeterminateEnVer = new JProgressBar(1, 0, 100);
        indeterminateEnVer.setIndeterminate(true);
        indeterminateEnVer.setStringPainted(true);
        indeterminateEnVer.setString("In progress");
        verticalBuilder.append(indeterminateEnVer);
        JProgressBar determinateDisVer = new JProgressBar(1, 0, 100);
        determinateDisVer.setIndeterminate(false);
        determinateDisVer.setEnabled(false);
        verticalBuilder.append(determinateDisVer);
        JProgressBar indeterminateDisVer = new JProgressBar(1, 0, 100);
        indeterminateDisVer.setIndeterminate(true);
        indeterminateDisVer.setEnabled(false);
        verticalBuilder.append(indeterminateDisVer);
        bars.add(verticalBuilder.getPanel());
        this.add((Component)new JScrollPane(bars), "Center");
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(1));
        final Timeline progressTimeline = new Timeline(this);
        @RunOnUIThread
        class ProgressCallback
        extends TimelineCallbackAdapter {
            ProgressCallback() {
            }

            @Override
            public void onTimelinePulse(float durationFraction, float timelinePosition) {
                ProgressBarPanel.delta(ProgressBarPanel.this, 1);
            }
        }
        progressTimeline.addCallback(new ProgressCallback());
        progressTimeline.setDuration(2000L);
        this.startButton = new JButton("start");
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                progressTimeline.playLoop(Timeline.RepeatBehavior.LOOP);
                ProgressBarPanel.this.startButton.setEnabled(false);
                ProgressBarPanel.this.stopButton.setEnabled(true);
            }
        });
        this.stopButton = new JButton("stop");
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                progressTimeline.cancel();
                ProgressBarPanel.this.stopButton.setEnabled(false);
                ProgressBarPanel.this.startButton.setEnabled(true);
            }
        });
        JButton plus10Button = new JButton("plus 10");
        plus10Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressBarPanel.delta(ProgressBarPanel.this, 10);
            }
        });
        buttons.add(plus10Button);
        JButton minus10Button = new JButton("minus 10");
        minus10Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressBarPanel.delta(ProgressBarPanel.this, -10);
            }
        });
        buttons.add(minus10Button);
        JButton plus1Button = new JButton("plus 1");
        plus1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressBarPanel.delta(ProgressBarPanel.this, 1);
            }
        });
        buttons.add(plus1Button);
        JButton minus1Button = new JButton("minus 1");
        minus1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressBarPanel.delta(ProgressBarPanel.this, -1);
            }
        });
        buttons.add(minus1Button);
        JButton resetButton = new JButton("reset");
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                progressTimeline.cancel();
                ProgressBarPanel.reset(ProgressBarPanel.this);
                ProgressBarPanel.this.stopButton.setEnabled(false);
                ProgressBarPanel.this.startButton.setEnabled(true);
            }
        });
        buttons.add(this.startButton);
        buttons.add(this.stopButton);
        buttons.add(resetButton);
        this.add((Component)buttons, "South");
    }

    protected static void delta(Component c, int delta) {
        JProgressBar pb;
        if (c instanceof JProgressBar && !(pb = (JProgressBar)c).isIndeterminate()) {
            int newValue = pb.getValue() + delta;
            if (newValue < pb.getMinimum()) {
                newValue = pb.getMinimum();
            }
            if (newValue > pb.getMaximum()) {
                newValue = pb.getMaximum();
            }
            pb.setValue(newValue);
        }
        if (c instanceof Container) {
            Container cont = (Container)c;
            int i = 0;
            while (i < cont.getComponentCount()) {
                ProgressBarPanel.delta(cont.getComponent(i), delta);
                ++i;
            }
        }
    }

    protected static void reset(Component c) {
        JProgressBar pb;
        if (c instanceof JProgressBar && !(pb = (JProgressBar)c).isIndeterminate()) {
            pb.setValue(pb.getMinimum());
        }
        if (c instanceof Container) {
            Container cont = (Container)c;
            int i = 0;
            while (i < cont.getComponentCount()) {
                ProgressBarPanel.reset(cont.getComponent(i));
                ++i;
            }
        }
    }
}

