/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import org.pushingpixels.lafwidget.preview.DefaultPreviewPainter;
import org.pushingpixels.substance.api.SubstanceConstants;
import test.Check;
import test.check.CheckeredPanel;
import test.check.ControllablePanel;
import test.check.ScrollablePanel;

public class ScrollPanel
extends ControllablePanel {
    private JScrollPane sp;
    private JPanel panel = new CheckeredPanel();

    public ScrollPanel() {
        this.sp = new JScrollPane(this.panel, 20, 30);
        this.setLayout(new BorderLayout());
        this.add((Component)this.sp, "Center");
        FormLayout lm = new FormLayout("right:pref, 4dlu, fill:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm, new ScrollablePanel());
        builder.appendSeparator("General settings");
        final JCheckBox isEnabled = new JCheckBox("is enabled");
        isEnabled.setSelected(true);
        isEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean toEnable = isEnabled.isSelected();
                ScrollPanel.this.sp.setEnabled(toEnable);
                ScrollPanel.this.updateEnabledState(ScrollPanel.this.sp, toEnable);
                Check.out("Scroll pane is " + toEnable);
            }
        });
        builder.append("Enabled", (Component)isEnabled);
        final JCheckBox hasNullBorder = new JCheckBox("Has null border");
        hasNullBorder.setSelected(false);
        hasNullBorder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (hasNullBorder.isSelected()) {
                    ScrollPanel.this.sp.setBorder(null);
                } else {
                    ScrollPanel.this.sp.setBorder(new LineBorder(Color.red));
                }
                ScrollPanel.this.sp.repaint();
            }
        });
        builder.append("Border", (Component)hasNullBorder);
        final JCheckBox hasPreview = new JCheckBox("Has preview");
        hasPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScrollPanel.this.sp.putClientProperty("lafwidgets.componentPreviewPainter", hasPreview.isSelected() ? new DefaultPreviewPainter() : null);
            }
        });
        builder.append("Preview", (Component)hasPreview);
        final JCheckBox hasAutoScroll = new JCheckBox("Has auto scroll");
        hasAutoScroll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScrollPanel.this.sp.putClientProperty("lafwidget.scroll.auto", hasAutoScroll.isSelected() ? Boolean.TRUE : null);
            }
        });
        builder.append("Auto scroll", (Component)hasAutoScroll);
        builder.appendSeparator("Scroll buttons settings");
        final JComboBox<Object> buttonPolicyCombo = new JComboBox<Object>(new Object[]{SubstanceConstants.ScrollPaneButtonPolicyKind.NONE, SubstanceConstants.ScrollPaneButtonPolicyKind.OPPOSITE, SubstanceConstants.ScrollPaneButtonPolicyKind.ADJACENT, SubstanceConstants.ScrollPaneButtonPolicyKind.MULTIPLE, SubstanceConstants.ScrollPaneButtonPolicyKind.MULTIPLE_BOTH});
        buttonPolicyCombo.setSelectedItem((Object)SubstanceConstants.ScrollPaneButtonPolicyKind.OPPOSITE);
        buttonPolicyCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubstanceConstants.ScrollPaneButtonPolicyKind buttonPolicy = (SubstanceConstants.ScrollPaneButtonPolicyKind)((Object)buttonPolicyCombo.getSelectedItem());
                ScrollPanel.this.sp.putClientProperty("substancelaf.scrollPaneButtonsPolicy", (Object)buttonPolicy);
                ScrollPanel.this.sp.repaint();
            }
        });
        builder.append("Button policy", buttonPolicyCombo);
        final JCheckBox isFlat = new JCheckBox("Is flat");
        isFlat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScrollPanel.this.sp.putClientProperty("substancelaf.componentFlat", isFlat.isSelected() ? Boolean.TRUE : null);
                ScrollPanel.this.sp.repaint();
            }
        });
        builder.append("Flat", (Component)isFlat);
        final JCheckBox isNever = new JCheckBox("Is never painted");
        isNever.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScrollPanel.this.sp.putClientProperty("substancelaf.buttonpaintnever", isNever.isSelected() ? Boolean.TRUE : null);
                ScrollPanel.this.sp.repaint();
            }
        });
        builder.append("Never", (Component)isNever);
        this.controlPanel = builder.getPanel();
    }

    void updateEnabledState(Container c, boolean enabled) {
        int counter = c.getComponentCount() - 1;
        while (counter >= 0) {
            Component child = c.getComponent(counter);
            child.setEnabled(enabled);
            if (child instanceof Container) {
                this.updateEnabledState((Container)child, enabled);
            }
            --counter;
        }
    }
}

