/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;
import test.check.ScrollablePanel;

public class SizesPanel
extends JPanel {
    private List<Mapping> model = new LinkedList<Mapping>();
    private JScrollPane central;

    public SizesPanel() {
        Font base = new Font("Tahoma", 0, 11);
        if (UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel) {
            base = SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null).getControlFont();
        }
        final Font baseFinal = base;
        this.model.add(new Mapping("buttons", new Creator(){

            @Override
            public JComponent create(int fontSize) {
                JButton result = new JButton("size " + fontSize);
                result.setFont(baseFinal.deriveFont((float)fontSize));
                return result;
            }
        }));
        this.model.add(new Mapping("toggle buttons", new Creator(){

            @Override
            public JComponent create(int fontSize) {
                JToggleButton result = new JToggleButton("size " + fontSize);
                result.setFont(baseFinal.deriveFont((float)fontSize));
                return result;
            }
        }));
        this.model.add(new Mapping("check boxes", new Creator(){

            @Override
            public JComponent create(int fontSize) {
                JCheckBox result = new JCheckBox("size " + fontSize);
                result.setFont(baseFinal.deriveFont((float)fontSize));
                return result;
            }
        }));
        this.model.add(new Mapping("radio buttons", new Creator(){

            @Override
            public JComponent create(int fontSize) {
                JRadioButton result = new JRadioButton("size " + fontSize);
                result.setFont(baseFinal.deriveFont((float)fontSize));
                return result;
            }
        }));
        this.model.add(new Mapping("combo boxes", new Creator(){

            @Override
            public JComponent create(int fontSize) {
                JComboBox<Object> result = new JComboBox<Object>(new Object[]{"size " + fontSize});
                result.setFont(baseFinal.deriveFont((float)fontSize));
                return result;
            }
        }));
        this.model.add(new Mapping("editable combo boxes", new Creator(){

            @Override
            public JComponent create(int fontSize) {
                JComboBox<Object> result = new JComboBox<Object>(new Object[]{"size " + fontSize});
                result.setEditable(true);
                result.setFont(baseFinal.deriveFont((float)fontSize));
                return result;
            }
        }));
        this.model.add(new Mapping("spinners", new Creator(){

            @Override
            public JComponent create(int fontSize) {
                JSpinner result = new JSpinner(new SpinnerNumberModel(fontSize, fontSize - 10, fontSize + 10, 1));
                result.setFont(baseFinal.deriveFont((float)fontSize));
                return result;
            }
        }));
        this.model.add(new Mapping("text fields", new Creator(){

            @Override
            public JComponent create(int fontSize) {
                JTextField result = new JTextField("size " + fontSize);
                result.setFont(baseFinal.deriveFont((float)fontSize));
                return result;
            }
        }));
        this.model.add(new Mapping("locked text fields", new Creator(){

            @Override
            public JComponent create(int fontSize) {
                JTextField result = new JTextField("size " + fontSize);
                result.setEditable(false);
                result.putClientProperty("lafwidgets.hasLockIcon", Boolean.TRUE);
                result.setFont(baseFinal.deriveFont((float)fontSize));
                return result;
            }
        }));
        this.model.add(new Mapping("password fields", new Creator(){

            @Override
            public JComponent create(int fontSize) {
                JPasswordField result = new JPasswordField("size " + fontSize);
                result.setFont(baseFinal.deriveFont((float)fontSize));
                return result;
            }
        }));
        this.model.add(new Mapping("progress bars", new Creator(){

            @Override
            public JComponent create(int fontSize) {
                JProgressBar result = new JProgressBar(0);
                result.setMinimum(0);
                result.setMaximum(100);
                result.setValue(60);
                result.setFont(baseFinal.deriveFont((float)fontSize));
                return result;
            }
        }));
        this.model.add(new Mapping("progress bars 2", new Creator(){

            @Override
            public JComponent create(int fontSize) {
                JProgressBar result = new JProgressBar(0);
                result.setMinimum(0);
                result.setMaximum(100);
                result.setValue(60);
                result.setStringPainted(true);
                result.setFont(baseFinal.deriveFont((float)fontSize));
                return result;
            }
        }));
        this.model.add(new Mapping("sliders", new Creator(){

            @Override
            public JComponent create(int fontSize) {
                JSlider result = new JSlider(0, 0, 100, 50);
                result.setFont(baseFinal.deriveFont((float)fontSize));
                return result;
            }
        }));
        this.model.add(new Mapping("sliders 2", new Creator(){

            @Override
            public JComponent create(int fontSize) {
                JSlider result = new JSlider(0, 0, 100, 50);
                result.setMajorTickSpacing(20);
                result.setMinorTickSpacing(5);
                result.setPaintLabels(true);
                result.setFont(baseFinal.deriveFont((float)fontSize));
                return result;
            }
        }));
        this.model.add(new Mapping("sliders 3", new Creator(){

            @Override
            public JComponent create(int fontSize) {
                JSlider result = new JSlider(0, 0, 100, 50);
                result.setMajorTickSpacing(20);
                result.setMinorTickSpacing(5);
                result.setPaintTicks(true);
                result.setFont(baseFinal.deriveFont((float)fontSize));
                return result;
            }
        }));
        this.model.add(new Mapping("sliders 4", new Creator(){

            @Override
            public JComponent create(int fontSize) {
                JSlider result = new JSlider(0, 0, 100, 50);
                result.setMajorTickSpacing(20);
                result.setMinorTickSpacing(5);
                result.setPaintTicks(true);
                result.setPaintLabels(true);
                result.setFont(baseFinal.deriveFont((float)fontSize));
                return result;
            }
        }));
        this.model.add(new Mapping("trees", new Creator(){

            @Override
            public JComponent create(int fontSize) {
                DefaultMutableTreeNode root = new DefaultMutableTreeNode("size " + fontSize);
                DefaultMutableTreeNode son1 = new DefaultMutableTreeNode("son1");
                DefaultMutableTreeNode gson11 = new DefaultMutableTreeNode("gson11");
                son1.add(gson11);
                root.add(son1);
                JTree result = new JTree(root);
                result.setFont(baseFinal.deriveFont((float)fontSize));
                return result;
            }
        }));
        this.model.add(new Mapping("lists", new Creator(){

            @Override
            public JComponent create(int fontSize) {
                JList<Object> result = new JList<Object>(new Object[]{"item1", "item2"});
                result.setFont(baseFinal.deriveFont((float)fontSize));
                return result;
            }
        }));
        this.model.add(new Mapping("tables", new Creator(){

            @Override
            public JComponent create(int fontSize) {
                DefaultTableModel model = new DefaultTableModel(){

                    @Override
                    public int getRowCount() {
                        return 2;
                    }

                    @Override
                    public int getColumnCount() {
                        return 3;
                    }

                    @Override
                    public Object getValueAt(int row, int column) {
                        return String.valueOf(row) + ":" + column;
                    }

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return false;
                    }

                    @Override
                    public String getColumnName(int column) {
                        return "Column " + column;
                    }
                };
                JTable result = new JTable(model);
                result.setFont(baseFinal.deriveFont((float)fontSize));
                return result;
            }
        }));
        final JList<Object> list = new JList<Object>(new AbstractListModel(){

            @Override
            public Object getElementAt(int index) {
                return SizesPanel.this.model.get(index);
            }

            @Override
            public int getSize() {
                return SizesPanel.this.model.size();
            }
        });
        if (UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel) {
            list.setCellRenderer(new SubstanceDefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    return super.getListCellRendererComponent(list, (Object)((Mapping)value).caption, index, isSelected, cellHasFocus);
                }
            });
        }
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(list), "West");
        list.setSelectionMode(0);
        list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (SizesPanel.this.central != null) {
                            SizesPanel.this.remove(SizesPanel.this.central);
                        }
                        SizesPanel.this.central = null;
                        int selIndex = list.getSelectedIndex();
                        if (selIndex >= 0) {
                            Mapping sel = (Mapping)list.getSelectedValue();
                            FormLayout lm = new FormLayout("right:pref, 4dlu, left:pref:grow", "");
                            DefaultFormBuilder builder = new DefaultFormBuilder(lm, new ScrollablePanel());
                            builder.setDefaultDialogBorder();
                            int fontSize = 11;
                            while (fontSize < 25) {
                                builder.append(String.valueOf(fontSize) + " pixels", (Component)sel.creator.create(fontSize));
                                ++fontSize;
                            }
                            builder.append("72 pixels", (Component)sel.creator.create(72));
                            SizesPanel.this.central = new JScrollPane(builder.getPanel(), 22, 31);
                            SizesPanel.this.add((Component)SizesPanel.this.central, "Center");
                            SizesPanel.this.doLayout();
                            SizesPanel.this.revalidate();
                        }
                    }
                });
            }
        });
    }

    private static interface Creator {
        public JComponent create(int var1);
    }

    private static class Mapping {
        public String caption;
        public Creator creator;

        public Mapping(String caption, Creator creator) {
            this.caption = caption;
            this.creator = creator;
        }
    }
}

