/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import test.check.ScrollablePanel;
import test.check.command.BackgroundColorCommand;
import test.check.command.ChainCommand;
import test.check.command.ClientPropertyCommand;
import test.check.command.ConfigurationCommand;
import test.check.command.CreationCommand;
import test.check.command.DisableCommand;

public class SpinnerPanel
extends JPanel {
    public SpinnerPanel() {
        this.setLayout(new BorderLayout());
        FormLayout lm = new FormLayout("right:pref, 4dlu, left:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm, new ScrollablePanel());
        builder.setDefaultDialogBorder();
        CreationCommand<Component> basicCr = new CreationCommand<Component>(){

            @Override
            public Component create() {
                JSpinner basicSpinner = new JSpinner(new SpinnerNumberModel());
                return basicSpinner;
            }
        };
        CreationCommand<Component> dateCr = new CreationCommand<Component>(){

            @Override
            public Component create() {
                JSpinner dateEnSpinner = new JSpinner(new SpinnerDateModel());
                return dateEnSpinner;
            }
        };
        CreationCommand<Component> weekdaysCr = new CreationCommand<Component>(){

            @Override
            public Component create() {
                Object[] weekdaysEn = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
                JSpinner listEnSpinner = new JSpinner(new SpinnerListModel(weekdaysEn));
                return listEnSpinner;
            }
        };
        CreationCommand<Component> numberCr = new CreationCommand<Component>(){

            @Override
            public Component create() {
                JSpinner numberEnSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 100, 5));
                return numberEnSpinner;
            }
        };
        builder.appendSeparator("Enabled");
        this.addSpinner(builder, "Basic", basicCr, null);
        this.addSpinner(builder, "Date", dateCr, null);
        this.addSpinner(builder, "Weekdays", weekdaysCr, null);
        this.addSpinner(builder, "Weekdays select on focus", weekdaysCr, new ClientPropertyCommand("lafwidgets.textSelectAllOnFocus", Boolean.TRUE));
        this.addSpinner(builder, "Number", numberCr, null);
        this.addSpinner(builder, "Number flat", numberCr, new ClientPropertyCommand("substancelaf.componentFlat", Boolean.TRUE));
        this.addSpinner(builder, "Number never", numberCr, new ClientPropertyCommand("substancelaf.buttonpaintnever", Boolean.TRUE));
        this.addSpinner(builder, "Number pink", numberCr, new BackgroundColorCommand(new Color(255, 128, 128)));
        builder.appendSeparator("Disabled");
        this.addSpinner(builder, "Basic", basicCr, new DisableCommand());
        this.addSpinner(builder, "Date", dateCr, new DisableCommand());
        this.addSpinner(builder, "Weekdays", weekdaysCr, new DisableCommand());
        this.addSpinner(builder, "Weekdays select on focus", weekdaysCr, new ChainCommand<Component>(new ClientPropertyCommand("lafwidgets.textSelectAllOnFocus", Boolean.TRUE), new DisableCommand()));
        this.addSpinner(builder, "Number", numberCr, new DisableCommand());
        this.addSpinner(builder, "Number flat", numberCr, new ChainCommand<Component>(new ClientPropertyCommand("substancelaf.componentFlat", Boolean.TRUE), new DisableCommand()));
        this.add((Component)new JScrollPane(builder.getPanel()), "Center");
    }

    private void addSpinner(DefaultFormBuilder builder, String label, CreationCommand<Component> creationCmd, ConfigurationCommand<Component> configurationCmd) {
        Component comp = creationCmd.create();
        if (configurationCmd != null) {
            configurationCmd.configure(comp);
        }
        JLabel jl = new JLabel(label);
        builder.append(jl);
        builder.append(comp);
    }
}

