/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;

public class SubstanceDiagonalGradientWatermark
implements SubstanceWatermark {
    @Override
    public void drawWatermarkImage(Graphics g, Component c, int x, int y, int width, int height) {
        if (!(c == null || c.isDisplayable() && c.isShowing())) {
            return;
        }
        Component parent = c;
        if (parent != null) {
            while (parent.getParent() != null) {
                parent = parent.getParent();
            }
        }
        if (!parent.isShowing()) {
            return;
        }
        int dx = parent != null ? c.getLocationOnScreen().x - parent.getLocationOnScreen().x : 0;
        int dy = parent != null ? c.getLocationOnScreen().y - parent.getLocationOnScreen().y : 0;
        int dw = parent != null ? parent.getWidth() : width;
        int dh = parent != null ? parent.getHeight() : height;
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setPaint(new GradientPaint(x - dx, y - dy, Color.gray, x - dx + dw, y - dy + dh, SubstanceLookAndFeel.getCurrentSkin(c).getColorScheme(c, ComponentState.ENABLED).getMidColor()));
        graphics.setComposite(AlphaComposite.getInstance(3, 0.8f));
        graphics.fillRect(x, y, width, height);
        graphics.dispose();
    }

    @Override
    public boolean updateWatermarkImage(SubstanceSkin skin) {
        return true;
    }

    @Override
    public void previewWatermark(Graphics g, SubstanceSkin skin, int x, int y, int width, int height) {
        this.drawWatermarkImage(g, null, x, y, width, height);
    }

    @Override
    public String getDisplayName() {
        return "Diagonal Gradient";
    }

    @Override
    public void dispose() {
    }
}

