/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SubstanceLafChanger
implements ActionListener {
    private JFrame frame;
    private String lafClassName;
    private boolean wasOriginallyDecoratedByOS;

    public static JMenuItem getMenuItem(JFrame frame, String lafName, String lafClassName) {
        JMenuItem result = new JMenuItem(lafName);
        result.addActionListener(new SubstanceLafChanger(frame, lafClassName));
        return result;
    }

    public SubstanceLafChanger(JFrame frame, String lafClassName) {
        this.frame = frame;
        this.lafClassName = lafClassName;
        this.wasOriginallyDecoratedByOS = !frame.isUndecorated();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean wasDecoratedByOS = !SubstanceLafChanger.this.frame.isUndecorated();
                try {
                    UIManager.setLookAndFeel(SubstanceLafChanger.this.lafClassName);
                    Window[] windowArray = Window.getWindows();
                    int n = windowArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Window window = windowArray[n2];
                        SwingUtilities.updateComponentTreeUI(window);
                        ++n2;
                    }
                    boolean canBeDecoratedByLAF = UIManager.getLookAndFeel().getSupportsWindowDecorations();
                    if (canBeDecoratedByLAF == wasDecoratedByOS) {
                        boolean wasVisible = SubstanceLafChanger.this.frame.isVisible();
                        SubstanceLafChanger.this.frame.setVisible(false);
                        SubstanceLafChanger.this.frame.dispose();
                        if (!canBeDecoratedByLAF || SubstanceLafChanger.this.wasOriginallyDecoratedByOS) {
                            SubstanceLafChanger.this.frame.setUndecorated(false);
                            SubstanceLafChanger.this.frame.getRootPane().setWindowDecorationStyle(0);
                        } else {
                            SubstanceLafChanger.this.frame.setUndecorated(true);
                            SubstanceLafChanger.this.frame.getRootPane().setWindowDecorationStyle(1);
                        }
                        SubstanceLafChanger.this.frame.setVisible(wasVisible);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    SubstanceLafChanger.out("LAF main class '" + SubstanceLafChanger.this.lafClassName + "' not found");
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });
    }

    public static void out(Object obj) {
        try {
            System.out.println(obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

