/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.pushingpixels.lafwidget.LafWidgetUtilities2;
import org.pushingpixels.lafwidget.utils.LafConstants;
import org.pushingpixels.substance.api.SubstanceConstants;
import test.check.FlexiComboBox;
import test.check.MyTabPreviewPainter;
import test.check.NumberedPanel;

public class TabControlPanel
extends JPanel {
    private JTabbedPane jtp;
    public LinkedList<Component> closed;

    private JPanel getContents(final JTabbedPane jtp, final MyTabPreviewPainter mainTabPreviewPainter) {
        FormLayout lm = new FormLayout("right:pref, 4dlu, fill:min:grow(1), 2dlu, fill:min:grow(1)", "p, 2dlu, p, 3dlu, p, 3dlu, p, 3dlu,  p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 7dlu, p, 2dlu, p, 0dlu, p, 0dlu, p, 0dlu, p, 7dlu,p, 2dlu, p, 3dlu, p, 0dlu, p, 3dlu, p, 3dlu, p, 7dlu, p, 2dlu, p, 0dlu, p, 0dlu, p, 0dlu, p, 7dlu, p, 2dlu, p, 3dlu, p");
        lm.setColumnGroups(new int[][]{{3, 5}});
        PanelBuilder builder = new PanelBuilder(lm);
        CellConstraints cc = new CellConstraints();
        int row = 1;
        builder.addSeparator("General", cc.xyw(1, row, 5));
        final JComboBox<Object> addKindCombo = new JComboBox<Object>(new Object[]{"regular", "null", "modified"});
        JButton addNewTabButton = new JButton("Add");
        addNewTabButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedKind = (String)addKindCombo.getSelectedItem();
                if ("null".equals(selectedKind)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jtp.addTab("null tab", null);
                        }
                    });
                    return;
                }
                final int count = 1 + jtp.getTabCount();
                final NumberedPanel tabComp = new NumberedPanel(count);
                if ("modified".equals(selectedKind)) {
                    tabComp.putClientProperty("windowModified", Boolean.TRUE);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jtp.addTab("tab" + count, tabComp);
                    }
                });
            }
        });
        builder.addLabel("Add tab", cc.xy(1, row += 2));
        builder.add(addKindCombo, cc.xy(3, row));
        builder.add((Component)addNewTabButton, cc.xy(5, row));
        final JComboBox<Object> placementCombo = new JComboBox<Object>(new Object[]{"top", "bottom", "left", "right"});
        placementCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selected = (String)placementCombo.getSelectedItem();
                if ("top".equals(selected)) {
                    jtp.setTabPlacement(1);
                }
                if ("bottom".equals(selected)) {
                    jtp.setTabPlacement(3);
                }
                if ("left".equals(selected)) {
                    jtp.setTabPlacement(2);
                }
                if ("right".equals(selected)) {
                    jtp.setTabPlacement(4);
                }
            }
        });
        builder.addLabel("Placement", cc.xy(1, row += 2));
        builder.add(placementCombo, cc.xyw(3, row, 3));
        try {
            final FlexiComboBox<LafConstants.TabOverviewKind> overviewKindCombo = new FlexiComboBox<LafConstants.TabOverviewKind>(new LafConstants.TabOverviewKind[]{LafConstants.TabOverviewKind.GRID, LafConstants.TabOverviewKind.MENU_CAROUSEL, LafConstants.TabOverviewKind.ROUND_CAROUSEL}){

                @Override
                public String getCaption(LafConstants.TabOverviewKind item) {
                    return item.getName();
                }
            };
            overviewKindCombo.setSelectedItem(LafWidgetUtilities2.getTabPreviewPainter((JTabbedPane)jtp).getOverviewKind(jtp));
            overviewKindCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mainTabPreviewPainter.setTabOverviewKind((LafConstants.TabOverviewKind)overviewKindCombo.getSelectedItem());
                }
            });
            builder.addLabel("Overview kind", cc.xy(1, row += 2));
            builder.add((Component)overviewKindCombo, cc.xyw(3, row, 3));
        }
        catch (NoClassDefFoundError overviewKindCombo) {
            // empty catch block
        }
        final JCheckBox useScrollLayout = new JCheckBox("Uses scroll layout");
        useScrollLayout.setSelected(false);
        useScrollLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jtp.setTabLayoutPolicy(useScrollLayout.isSelected() ? 1 : 0);
            }
        });
        builder.addLabel("Layout", cc.xy(1, row += 2));
        builder.add((Component)useScrollLayout, cc.xyw(3, row, 3));
        final JComboBox<Object> contentBorderCombo = new JComboBox<Object>(new Object[]{SubstanceConstants.TabContentPaneBorderKind.DOUBLE_FULL, SubstanceConstants.TabContentPaneBorderKind.SINGLE_FULL, SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT, SubstanceConstants.TabContentPaneBorderKind.SINGLE_PLACEMENT});
        contentBorderCombo.setSelectedItem((Object)SubstanceConstants.TabContentPaneBorderKind.DOUBLE_FULL);
        contentBorderCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubstanceConstants.TabContentPaneBorderKind contentBorderKind = (SubstanceConstants.TabContentPaneBorderKind)((Object)contentBorderCombo.getSelectedItem());
                jtp.putClientProperty("substancelaf.tabbedPaneContentBorderKind", (Object)contentBorderKind);
                jtp.updateUI();
                jtp.repaint();
            }
        });
        builder.addLabel("Content border", cc.xy(1, row += 2));
        builder.add(contentBorderCombo, cc.xyw(3, row, 3));
        JButton enableAll = new JButton("+ all");
        enableAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = 0;
                while (i < jtp.getTabCount()) {
                    jtp.setEnabledAt(i, true);
                    ++i;
                }
            }
        });
        JButton disableAll = new JButton("- all");
        disableAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = 0;
                while (i < jtp.getTabCount()) {
                    jtp.setEnabledAt(i, false);
                    ++i;
                }
            }
        });
        builder.addLabel("Enable all", cc.xy(1, row += 2));
        builder.add((Component)enableAll, cc.xy(3, row));
        builder.add((Component)disableAll, cc.xy(5, row));
        JButton closeAllEnabled = new JButton("Close");
        closeAllEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HashSet<Component> toRemove = new HashSet<Component>();
                int i = 0;
                while (i < jtp.getTabCount()) {
                    if (jtp.isEnabledAt(i)) {
                        toRemove.add(jtp.getComponentAt(i));
                    }
                    ++i;
                }
                for (Component comp : toRemove) {
                    jtp.remove(comp);
                }
            }
        });
        JButton restoreClosed = new JButton("Restore");
        restoreClosed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Component tnp : TabControlPanel.this.closed) {
                    jtp.addTab("restored", tnp);
                }
            }
        });
        builder.addLabel("Close all", cc.xy(1, row += 2));
        builder.add((Component)closeAllEnabled, cc.xy(3, row));
        builder.add((Component)restoreClosed, cc.xy(5, row));
        builder.addSeparator("Single Tab", cc.xyw(1, row += 2, 5));
        final JComboBox tabSelectorCombo = new JComboBox(new TabComboBoxModel(this.jtp));
        tabSelectorCombo.setRenderer(new TabCellRenderer());
        jtp.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                ((TabComboBoxModel)tabSelectorCombo.getModel()).changed();
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                ((TabComboBoxModel)tabSelectorCombo.getModel()).changed();
            }
        });
        builder.addLabel("Select", cc.xy(1, row += 2));
        builder.add(tabSelectorCombo, cc.xyw(3, row, 3));
        final JCheckBox markAsModified = new JCheckBox("Marked modified");
        markAsModified.setSelected(false);
        markAsModified.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (tabSelectorCombo.getSelectedItem() == null) {
                    return;
                }
                Component comp = jtp.getComponentAt((Integer)tabSelectorCombo.getSelectedItem());
                if (comp != null && comp instanceof JComponent) {
                    JComponent jc = (JComponent)comp;
                    jc.putClientProperty("windowModified", markAsModified.isSelected() ? Boolean.TRUE : false);
                }
            }
        });
        tabSelectorCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Component selComp = jtp.getComponentAt((Integer)tabSelectorCombo.getSelectedItem());
                if (selComp != null && selComp instanceof JComponent) {
                    JComponent selected = (JComponent)selComp;
                    markAsModified.setSelected(Boolean.TRUE.equals(selected.getClientProperty("windowModified")));
                }
            }
        });
        builder.addLabel("Modified", cc.xy(1, row += 2));
        builder.add((Component)markAsModified, cc.xyw(3, row, 3));
        final JCheckBox isModifiedAnimOnClose = new JCheckBox("Animation on X");
        isModifiedAnimOnClose.setSelected(false);
        isModifiedAnimOnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (tabSelectorCombo.getSelectedItem() == null) {
                    return;
                }
                Component comp = jtp.getComponentAt((Integer)tabSelectorCombo.getSelectedItem());
                if (comp != null && comp instanceof JComponent) {
                    JComponent jc = (JComponent)comp;
                    jc.putClientProperty("substancelaf.tabbedpaneclosebuttonsmodifiedanimation", isModifiedAnimOnClose.isSelected() ? Boolean.TRUE : null);
                }
            }
        });
        tabSelectorCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Component selComp = jtp.getComponentAt((Integer)tabSelectorCombo.getSelectedItem());
                if (selComp != null && selComp instanceof JComponent) {
                    JComponent selected = (JComponent)selComp;
                    isModifiedAnimOnClose.setSelected(Boolean.TRUE.equals(selected.getClientProperty("substancelaf.tabbedpaneclosebuttonsmodifiedanimation")));
                }
            }
        });
        builder.add((Component)isModifiedAnimOnClose, cc.xyw(3, row += 2, 3));
        final JCheckBox hasCloseButton = new JCheckBox("No close button");
        hasCloseButton.setSelected(false);
        hasCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (tabSelectorCombo.getSelectedItem() == null) {
                    return;
                }
                Component comp = jtp.getComponentAt((Integer)tabSelectorCombo.getSelectedItem());
                if (comp != null && comp instanceof JComponent) {
                    JComponent jc = (JComponent)comp;
                    jc.putClientProperty("substancelaf.tabbedpanehasclosebuttons", hasCloseButton.isSelected() ? Boolean.FALSE : null);
                    jtp.repaint();
                }
            }
        });
        tabSelectorCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Component selComp = jtp.getComponentAt((Integer)tabSelectorCombo.getSelectedItem());
                if (selComp != null && selComp instanceof JComponent) {
                    JComponent selected = (JComponent)selComp;
                    hasCloseButton.setSelected(Boolean.FALSE.equals(selected.getClientProperty("substancelaf.tabbedpanehasclosebuttons")));
                }
            }
        });
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (tabSelectorCombo.getSelectedItem() == null) {
                            return;
                        }
                        Component comp = jtp.getComponentAt((Integer)tabSelectorCombo.getSelectedItem());
                        jtp.removeTabAt((Integer)tabSelectorCombo.getSelectedItem());
                        (this).TabControlPanel.this.closed.add(comp);
                        jtp.repaint();
                    }
                });
            }
        });
        JButton selectButton = new JButton("Select");
        selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (tabSelectorCombo.getSelectedItem() == null) {
                            return;
                        }
                        jtp.setSelectedIndex((Integer)tabSelectorCombo.getSelectedItem());
                    }
                });
            }
        });
        builder.addLabel("Tab op", cc.xy(1, row += 2));
        builder.add((Component)closeButton, cc.xy(3, row));
        builder.add((Component)selectButton, cc.xy(5, row));
        builder.addSeparator("Close Button Single", cc.xyw(1, row += 2, 5));
        builder.addLabel("Visible", cc.xy(1, row += 2));
        builder.add((Component)hasCloseButton, cc.xyw(3, row, 3));
        return builder.getPanel();
    }

    public TabControlPanel(JTabbedPane jtp, MyTabPreviewPainter previewPainter) {
        this.jtp = jtp;
        this.closed = new LinkedList();
        this.setLayout(new BorderLayout());
        JPanel contents = this.getContents(jtp, previewPainter);
        contents.setOpaque(false);
        contents.putClientProperty("substancelaf.buttonnominsize", Boolean.TRUE);
        this.add((Component)contents, "Center");
    }

    private class TabCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private TabCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                this.setText("");
                this.setIcon(null);
            } else {
                this.setText(TabControlPanel.this.jtp.getTitleAt((Integer)value));
                this.setIcon(TabControlPanel.this.jtp.getIconAt((Integer)value));
            }
            return this;
        }
    }

    private static class TabComboBoxModel
    extends DefaultComboBoxModel {
        private JTabbedPane jtp;

        public TabComboBoxModel(JTabbedPane jtp) {
            this.jtp = jtp;
        }

        @Override
        public int getSize() {
            return this.jtp.getTabCount();
        }

        @Override
        public Object getElementAt(int index) {
            return index;
        }

        @Override
        public int getIndexOf(Object anObject) {
            return (Integer)anObject;
        }

        public void changed() {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }
}

