/*
 * Decompiled with CFR 0.152.
 */
package test.check.decoration;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;
import test.check.SubstanceSkinComboSelector;

public class DecorationLists
extends JFrame {
    public DecorationLists() {
        super("Lists in decoration areas");
        JPanel listsPanel = new JPanel(new GridLayout(2, 4));
        listsPanel.add(new ListPanel("Enabled in HEADER", DecorationAreaType.HEADER, true));
        listsPanel.add(new ListPanel("Disabled in HEADER", DecorationAreaType.HEADER, false));
        listsPanel.add(new ListPanel("Enabled in NONE", DecorationAreaType.NONE, true));
        listsPanel.add(new ListPanel("Disabled in NONE", DecorationAreaType.NONE, false));
        listsPanel.add(new ListPanel("Enabled in GENERAL", DecorationAreaType.GENERAL, true));
        listsPanel.add(new ListPanel("Disabled in GENERAL", DecorationAreaType.GENERAL, false));
        listsPanel.add(new ListPanel("Enabled in FOOTER", DecorationAreaType.FOOTER, true));
        listsPanel.add(new ListPanel("Disabled in FOOTER", DecorationAreaType.FOOTER, false));
        this.setLayout(new BorderLayout());
        this.add((Component)listsPanel, "Center");
        JPanel controlPanel = new JPanel(new FlowLayout(2));
        controlPanel.add(new SubstanceSkinComboSelector());
        this.add((Component)controlPanel, "South");
        this.setSize(500, 400);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                new DecorationLists().setVisible(true);
            }
        });
    }

    private static class ListPanel
    extends JPanel {
        public ListPanel(String caption, DecorationAreaType decorationAreaType, boolean isEnabled) {
            super(new BorderLayout());
            SubstanceLookAndFeel.setDecorationType(this, decorationAreaType);
            JLabel captionLabel = new JLabel(" " + caption);
            Font font = captionLabel.getFont();
            captionLabel.setFont(font.deriveFont(1));
            this.add((Component)captionLabel, "North");
            JList<Object> list = new JList<Object>(new Object[]{"entry1", "entry2", "entry3", "entry4"});
            list.setEnabled(isEnabled);
            this.add(list, "Center");
        }
    }
}

