/*
 * Decompiled with CFR 0.152.
 */
package test.check.statusbar;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FontUIResource;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.fonts.FontPolicy;
import org.pushingpixels.substance.api.fonts.FontSet;

public class FontSizePanel {
    public static JPanel getPanel() {
        FormLayout lm = new FormLayout("fill:pref, 2dlu, fill:pref, 0dlu, fill:min:grow, 0dlu, fill:pref, 2dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm);
        builder.setBorder(new EmptyBorder(0, 0, 0, 0));
        final JLabel fontSizeLabel = new JLabel();
        fontSizeLabel.setText(String.valueOf(SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null).getControlFont().getSize()) + " pt.");
        builder.append(fontSizeLabel);
        ImageIcon zoomOutIcon = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("test/check/icons/16/zoom_out.png"));
        JLabel zoomOutLabel = new JLabel(zoomOutIcon);
        builder.append(zoomOutLabel);
        final JSlider fontSizeSlider = new JSlider(0, 10, 0);
        fontSizeSlider.setFocusable(false);
        fontSizeSlider.setToolTipText("Controls the global font set size. Resets Substance as the current LAF.");
        fontSizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!fontSizeSlider.getModel().getValueIsAdjusting()) {
                    final int newValue = fontSizeSlider.getValue();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SubstanceLookAndFeel.setFontPolicy(null);
                            final FontSet substanceCoreFontSet = SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null);
                            FontPolicy newFontPolicy = new FontPolicy(){

                                @Override
                                public FontSet getFontSet(String lafName, UIDefaults table) {
                                    return new WrapperFontSet(substanceCoreFontSet, newValue);
                                }
                            };
                            SubstanceLookAndFeel.setFontPolicy(newFontPolicy);
                            fontSizeLabel.setText(String.valueOf(SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null).getControlFont().getSize()) + " pt.");
                        }
                    });
                }
            }
        });
        builder.append(fontSizeSlider);
        ImageIcon zoomInIcon = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("test/check/icons/16/zoom_in.png"));
        JLabel zoomInLabel = new JLabel(zoomInIcon);
        builder.append(zoomInLabel);
        JButton tahoma = new JButton("Tahoma 11");
        tahoma.putClientProperty("substancelaf.buttonnominsize", Boolean.TRUE);
        tahoma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SubstanceLookAndFeel.setFontPolicy(null);
                        FontPolicy newFontPolicy = new FontPolicy(){

                            @Override
                            public FontSet getFontSet(String lafName, UIDefaults table) {
                                return new Tahoma11FontSet();
                            }
                        };
                        SubstanceLookAndFeel.setFontPolicy(newFontPolicy);
                        fontSizeLabel.setText(String.valueOf(SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null).getControlFont().getSize()) + " pt.");
                    }
                });
            }
        });
        builder.append(tahoma);
        JPanel result = builder.getPanel();
        return result;
    }

    private static class Tahoma11FontSet
    implements FontSet {
        private FontUIResource tahoma11 = new FontUIResource("Tahoma", 0, 11);

        private Tahoma11FontSet() {
        }

        @Override
        public FontUIResource getControlFont() {
            return this.tahoma11;
        }

        @Override
        public FontUIResource getMenuFont() {
            return this.tahoma11;
        }

        @Override
        public FontUIResource getMessageFont() {
            return this.tahoma11;
        }

        @Override
        public FontUIResource getSmallFont() {
            return this.tahoma11;
        }

        @Override
        public FontUIResource getTitleFont() {
            return this.tahoma11;
        }

        @Override
        public FontUIResource getWindowTitleFont() {
            return this.tahoma11;
        }
    }

    private static class WrapperFontSet
    implements FontSet {
        private int extra;
        private FontSet delegate;

        public WrapperFontSet(FontSet delegate, int extra) {
            this.delegate = delegate;
            this.extra = extra;
        }

        private FontUIResource getWrappedFont(FontUIResource systemFont) {
            return new FontUIResource(systemFont.getFontName(), systemFont.getStyle(), systemFont.getSize() + this.extra);
        }

        @Override
        public FontUIResource getControlFont() {
            return this.getWrappedFont(this.delegate.getControlFont());
        }

        @Override
        public FontUIResource getMenuFont() {
            return this.getWrappedFont(this.delegate.getMenuFont());
        }

        @Override
        public FontUIResource getMessageFont() {
            return this.getWrappedFont(this.delegate.getMessageFont());
        }

        @Override
        public FontUIResource getSmallFont() {
            return this.getWrappedFont(this.delegate.getSmallFont());
        }

        @Override
        public FontUIResource getTitleFont() {
            return this.getWrappedFont(this.delegate.getTitleFont());
        }

        @Override
        public FontUIResource getWindowTitleFont() {
            return this.getWrappedFont(this.delegate.getWindowTitleFont());
        }
    }
}

