/*
 * Decompiled with CFR 0.152.
 */
package test.samples.lafwidget.clientprop;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;

public class AutoScroll
extends JFrame {
    public AutoScroll() {
        super("Auto scroll");
        this.setLayout(new BorderLayout());
        JPanel samplePanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D graphics = (Graphics2D)g.create();
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, new Color(100, 100, 255), this.getWidth(), this.getHeight(), new Color(255, 100, 100)));
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics.dispose();
            }
        };
        samplePanel.setPreferredSize(new Dimension(800, 400));
        samplePanel.setSize(this.getPreferredSize());
        samplePanel.setMinimumSize(this.getPreferredSize());
        final JScrollPane scrollPane = new JScrollPane(samplePanel);
        this.add((Component)scrollPane, "Center");
        JPanel controls = new JPanel(new FlowLayout(2));
        final JCheckBox hasAutoScroll = new JCheckBox("has auto scroll");
        hasAutoScroll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        scrollPane.putClientProperty("lafwidget.scroll.auto", hasAutoScroll.isSelected() ? Boolean.TRUE : null);
                        AutoScroll.this.repaint();
                    }
                });
            }
        });
        controls.add(hasAutoScroll);
        this.add((Component)controls, "South");
        this.setSize(400, 200);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                new AutoScroll().setVisible(true);
            }
        });
    }
}

