/*
 * Decompiled with CFR 0.152.
 */
package test.samples.substance.api;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FontUIResource;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.fonts.FontPolicy;
import org.pushingpixels.substance.api.fonts.FontSet;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;

public class GetFontPolicy
extends JFrame {
    public GetFontPolicy() {
        super("Get font policy");
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout());
        final JSlider fontSizeSlider = new JSlider(-3, 3, 0);
        fontSizeSlider.setPaintLabels(true);
        fontSizeSlider.setMajorTickSpacing(1);
        fontSizeSlider.setToolTipText("Controls the global font set size");
        fontSizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!fontSizeSlider.getModel().getValueIsAdjusting()) {
                    final int newValue = fontSizeSlider.getValue();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SubstanceLookAndFeel.setFontPolicy(null);
                            final FontSet substanceCoreFontSet = SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null);
                            FontPolicy newFontPolicy = new FontPolicy(){

                                @Override
                                public FontSet getFontSet(String lafName, UIDefaults table) {
                                    return new WrapperFontSet(substanceCoreFontSet, newValue);
                                }
                            };
                            try {
                                GetFontPolicy.this.setCursor(Cursor.getPredefinedCursor(3));
                                SubstanceLookAndFeel.setFontPolicy(newFontPolicy);
                                GetFontPolicy.this.setCursor(Cursor.getDefaultCursor());
                            }
                            catch (Exception exc) {
                                exc.printStackTrace();
                            }
                        }
                    });
                }
            }
        });
        panel.add(fontSizeSlider);
        JButton jb = new JButton("Show font info");
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontPolicy fontPolicy = SubstanceLookAndFeel.getFontPolicy();
                FontSet fontSet = fontPolicy.getFontSet("Substance", null);
                String[] infoArray = new String[]{"Control: " + fontSet.getControlFont(), "Menu: " + fontSet.getMenuFont(), "Message: " + fontSet.getMessageFont(), "Small: " + fontSet.getSmallFont(), "Title: " + fontSet.getTitleFont(), "Window title: " + fontSet.getWindowTitleFont()};
                JList<String> infoList = new JList<String>(infoArray);
                JDialog infoDialog = new JDialog(GetFontPolicy.this, "Font set info", true);
                infoDialog.setLayout(new BorderLayout());
                infoDialog.add(infoList, "Center");
                infoDialog.pack();
                infoDialog.setLocationRelativeTo(GetFontPolicy.this);
                infoDialog.setVisible(true);
            }
        });
        panel.add(jb);
        this.add((Component)panel, "Center");
        this.setSize(400, 200);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                new GetFontPolicy().setVisible(true);
            }
        });
    }

    private static class WrapperFontSet
    implements FontSet {
        private int extra;
        private FontSet delegate;

        public WrapperFontSet(FontSet delegate, int extra) {
            this.delegate = delegate;
            this.extra = extra;
        }

        private FontUIResource getWrappedFont(FontUIResource systemFont) {
            return new FontUIResource(systemFont.getFontName(), systemFont.getStyle(), systemFont.getSize() + this.extra);
        }

        @Override
        public FontUIResource getControlFont() {
            return this.getWrappedFont(this.delegate.getControlFont());
        }

        @Override
        public FontUIResource getMenuFont() {
            return this.getWrappedFont(this.delegate.getMenuFont());
        }

        @Override
        public FontUIResource getMessageFont() {
            return this.getWrappedFont(this.delegate.getMessageFont());
        }

        @Override
        public FontUIResource getSmallFont() {
            return this.getWrappedFont(this.delegate.getSmallFont());
        }

        @Override
        public FontUIResource getTitleFont() {
            return this.getWrappedFont(this.delegate.getTitleFont());
        }

        @Override
        public FontUIResource getWindowTitleFont() {
            return this.getWrappedFont(this.delegate.getWindowTitleFont());
        }
    }
}

