/*
 * Decompiled with CFR 0.152.
 */
package test.samples.substance.api;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;
import org.pushingpixels.substance.api.skin.SkinChangeListener;
import org.pushingpixels.substance.api.skin.SkinInfo;

public class RegisterSkinChangeListener
extends JFrame {
    public RegisterSkinChangeListener() {
        super("Register skin change listener");
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout());
        JComboBox<String> cb = new JComboBox<String>(new Vector<String>(SubstanceLookAndFeel.getAllSkins().keySet()));
        cb.setSelectedIndex(-1);
        cb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                final Object item = evt.getItem();
                if (evt.getStateChange() == 1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SkinInfo skinInfo = SubstanceLookAndFeel.getAllSkins().get(item);
                                SubstanceLookAndFeel.setSkin(skinInfo.getClassName());
                                SwingUtilities.updateComponentTreeUI(RegisterSkinChangeListener.this);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        });
        panel.add(new JLabel("All skins:"));
        panel.add(cb);
        this.add((Component)panel, "Center");
        SubstanceLookAndFeel.registerSkinChangeListener(new SkinChangeListener(){

            @Override
            public void skinChanged() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(RegisterSkinChangeListener.this, "Skin changed");
                    }
                });
            }
        });
        this.setSize(400, 200);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                new RegisterSkinChangeListener().setVisible(true);
            }
        });
    }
}

