/*
 * Decompiled with CFR 0.152.
 */
package test.samples.substance.api;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;
import org.pushingpixels.substance.api.tabbed.TabCloseCallback;
import org.pushingpixels.substance.api.tabbed.VetoableMultipleTabCloseListener;

public class RegisterTabCloseChangeListener_GeneralMultipleVetoable
extends JFrame {
    public RegisterTabCloseChangeListener_GeneralMultipleVetoable() {
        super("Register tab close listener");
        this.setLayout(new BorderLayout());
        JTabbedPane jtp = new JTabbedPane();
        jtp.addTab("tab1", new JPanel());
        jtp.addTab("tab2", new JPanel());
        jtp.addTab("tab3", new JPanel());
        jtp.putClientProperty("substancelaf.tabbedpanehasclosebuttons", Boolean.TRUE);
        TabCloseCallback closeCallback = new TabCloseCallback(){

            @Override
            public SubstanceConstants.TabCloseKind onAreaClick(JTabbedPane tabbedPane, int tabIndex, MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 3) {
                    return SubstanceConstants.TabCloseKind.NONE;
                }
                if (mouseEvent.isShiftDown()) {
                    return SubstanceConstants.TabCloseKind.ALL;
                }
                return SubstanceConstants.TabCloseKind.THIS;
            }

            @Override
            public SubstanceConstants.TabCloseKind onCloseButtonClick(JTabbedPane tabbedPane, int tabIndex, MouseEvent mouseEvent) {
                if (mouseEvent.isAltDown()) {
                    return SubstanceConstants.TabCloseKind.ALL_BUT_THIS;
                }
                if (mouseEvent.isShiftDown()) {
                    return SubstanceConstants.TabCloseKind.ALL;
                }
                return SubstanceConstants.TabCloseKind.THIS;
            }

            @Override
            public String getAreaTooltip(JTabbedPane tabbedPane, int tabIndex) {
                return null;
            }

            @Override
            public String getCloseButtonTooltip(JTabbedPane tabbedPane, int tabIndex) {
                StringBuffer result = new StringBuffer();
                result.append("<html><body>");
                result.append("Mouse click closes <b>" + tabbedPane.getTitleAt(tabIndex) + "</b> tab");
                result.append("<br><b>Alt</b>-Mouse click closes all tabs but <b>" + tabbedPane.getTitleAt(tabIndex) + "</b> tab");
                result.append("<br><b>Shift</b>-Mouse click closes all tabs");
                result.append("</body></html>");
                return result.toString();
            }
        };
        jtp.putClientProperty("substancelaf.tabbedpanecloseCallback", closeCallback);
        SubstanceLookAndFeel.registerTabCloseChangeListener(new VetoableMultipleTabCloseListener(){

            @Override
            public void tabsClosing(JTabbedPane tabbedPane, Set<Component> tabComponents) {
                StringBuffer sb = new StringBuffer("Tab (s)");
                String sep = " [";
                for (Component comp : tabComponents) {
                    sb.append(sep);
                    sep = ", ";
                    sb.append(tabbedPane.getTitleAt(tabbedPane.indexOfComponent(comp)));
                }
                sb.append("] closing");
                System.out.println(sb.toString());
            }

            @Override
            public void tabsClosed(JTabbedPane tabbedPane, Set<Component> tabComponents) {
                System.out.println(String.valueOf(tabComponents.size()) + " tab(s) closed");
            }

            @Override
            public boolean vetoTabsClosing(JTabbedPane tabbedPane, Set<Component> tabComponents) {
                StringBuffer sb = new StringBuffer("");
                String sep = "[";
                for (Component comp : tabComponents) {
                    sb.append(sep);
                    sep = ", ";
                    sb.append(tabbedPane.getTitleAt(tabbedPane.indexOfComponent(comp)));
                }
                sb.append("]");
                return JOptionPane.showConfirmDialog(RegisterTabCloseChangeListener_GeneralMultipleVetoable.this, "Are you sure you want to close " + sb.toString() + "?") != 0;
            }
        });
        this.add((Component)jtp, "Center");
        this.setSize(400, 200);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                new RegisterTabCloseChangeListener_GeneralMultipleVetoable().setVisible(true);
            }
        });
    }
}

