/*
 * Decompiled with CFR 0.152.
 */
package test.samples.substance.clientprop;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;

public class ColorizationFactor
extends JFrame {
    public ColorizationFactor() {
        super("Colorization factor");
        this.setLayout(new BorderLayout());
        final JPanel panel = new JPanel(new FlowLayout());
        JButton button = new JButton("sample");
        button.setBackground(Color.yellow);
        button.setForeground(Color.red);
        panel.add(button);
        JCheckBox checkbox = new JCheckBox("sample");
        checkbox.setSelected(true);
        checkbox.setBackground(Color.green.brighter());
        checkbox.setForeground(Color.blue.darker());
        panel.add(checkbox);
        JRadioButton radiobutton = new JRadioButton("sample");
        radiobutton.setSelected(true);
        radiobutton.setBackground(Color.yellow);
        radiobutton.setForeground(Color.green.darker());
        panel.add(radiobutton);
        this.add((Component)panel, "Center");
        JPanel controls = new JPanel(new FlowLayout(2));
        final JSlider colorizationSlider = new JSlider(0, 100, 50);
        colorizationSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double val = (double)colorizationSlider.getValue() / 100.0;
                panel.putClientProperty("substancelaf.colorizationFactor", new Double(val));
                panel.repaint();
            }
        });
        controls.add(colorizationSlider);
        this.add((Component)controls, "South");
        this.setSize(400, 200);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                new ColorizationFactor().setVisible(true);
            }
        });
    }
}

