/*
 * Decompiled with CFR 0.152.
 */
package test.samples.substance.clientprop;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;

public class ScrollPaneButtonsPolicy
extends JFrame {
    public ScrollPaneButtonsPolicy() {
        super("Scroll pane buttons policy");
        this.setLayout(new BorderLayout());
        JPanel samplePanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D graphics = (Graphics2D)g.create();
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, new Color(100, 100, 255), this.getWidth(), this.getHeight(), new Color(255, 100, 100)));
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics.dispose();
            }
        };
        samplePanel.setPreferredSize(new Dimension(800, 250));
        samplePanel.setSize(this.getPreferredSize());
        samplePanel.setMinimumSize(this.getPreferredSize());
        final JScrollPane scrollPane = new JScrollPane(samplePanel);
        this.add((Component)scrollPane, "Center");
        JPanel controls = new JPanel(new FlowLayout(2));
        final JComboBox<Object> buttonsPolicyCombo = new JComboBox<Object>(new Object[]{SubstanceConstants.ScrollPaneButtonPolicyKind.NONE, SubstanceConstants.ScrollPaneButtonPolicyKind.OPPOSITE, SubstanceConstants.ScrollPaneButtonPolicyKind.ADJACENT, SubstanceConstants.ScrollPaneButtonPolicyKind.MULTIPLE, SubstanceConstants.ScrollPaneButtonPolicyKind.MULTIPLE_BOTH});
        buttonsPolicyCombo.setSelectedItem((Object)SubstanceConstants.ScrollPaneButtonPolicyKind.OPPOSITE);
        buttonsPolicyCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubstanceConstants.ScrollPaneButtonPolicyKind buttonPolicy = (SubstanceConstants.ScrollPaneButtonPolicyKind)((Object)buttonsPolicyCombo.getSelectedItem());
                scrollPane.putClientProperty("substancelaf.scrollPaneButtonsPolicy", (Object)buttonPolicy);
                scrollPane.repaint();
            }
        });
        controls.add(new JLabel("Buttons policy"));
        controls.add(buttonsPolicyCombo);
        this.add((Component)controls, "South");
        this.setSize(400, 200);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                new ScrollPaneButtonsPolicy().setVisible(true);
            }
        });
    }
}

