/*
 * Decompiled with CFR 0.152.
 */
package test.samples.substance.clientprop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;
import org.pushingpixels.substance.api.tabbed.TabCloseCallback;

public class TabbedPaneCloseCallback
extends JFrame {
    public TabbedPaneCloseCallback() {
        super("Tabbed pane close callback");
        this.setLayout(new BorderLayout());
        JTabbedPane jtp = new JTabbedPane();
        jtp.addTab("First", new JPanel());
        jtp.addTab("Second", new JPanel());
        jtp.addTab("Third", new JPanel());
        jtp.putClientProperty("substancelaf.tabbedpanehasclosebuttons", Boolean.TRUE);
        this.add((Component)jtp, "Center");
        TabCloseCallback closeCallback = new TabCloseCallback(){

            @Override
            public SubstanceConstants.TabCloseKind onAreaClick(JTabbedPane tabbedPane, int tabIndex, MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 3) {
                    return SubstanceConstants.TabCloseKind.NONE;
                }
                if (mouseEvent.isShiftDown()) {
                    return SubstanceConstants.TabCloseKind.ALL;
                }
                return SubstanceConstants.TabCloseKind.THIS;
            }

            @Override
            public SubstanceConstants.TabCloseKind onCloseButtonClick(JTabbedPane tabbedPane, int tabIndex, MouseEvent mouseEvent) {
                if (mouseEvent.isAltDown()) {
                    return SubstanceConstants.TabCloseKind.ALL_BUT_THIS;
                }
                if (mouseEvent.isShiftDown()) {
                    return SubstanceConstants.TabCloseKind.ALL;
                }
                return SubstanceConstants.TabCloseKind.THIS;
            }

            @Override
            public String getAreaTooltip(JTabbedPane tabbedPane, int tabIndex) {
                return null;
            }

            @Override
            public String getCloseButtonTooltip(JTabbedPane tabbedPane, int tabIndex) {
                StringBuffer result = new StringBuffer();
                result.append("<html><body>");
                result.append("Mouse click closes <b>" + tabbedPane.getTitleAt(tabIndex) + "</b> tab");
                result.append("<br><b>Alt</b>-Mouse click closes all tabs but <b>" + tabbedPane.getTitleAt(tabIndex) + "</b> tab");
                result.append("<br><b>Shift</b>-Mouse click closes all tabs");
                result.append("</body></html>");
                return result.toString();
            }
        };
        jtp.putClientProperty("substancelaf.tabbedpanecloseCallback", closeCallback);
        this.setSize(400, 200);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                new TabbedPaneCloseCallback().setVisible(true);
            }
        });
    }
}

