/*
 * Decompiled with CFR 0.152.
 */
package tools.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.internal.utils.border.SubstanceBorder;

public class JImageComponent
extends JPanel {
    private BufferedImage image;
    private double leftX;
    private double topY;
    private double zoom;
    private boolean isDragging;
    private Point lastDragPoint;
    private Color selectedColor;
    private Color rolloverColor;
    private File originalFile;
    private String[] legend;

    public JImageComponent(boolean hasKeyboardZoom) {
        this.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                if (support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    return true;
                }
                if (support.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                    return true;
                }
                DataFlavor[] dataFlavorArray = support.getDataFlavors();
                int n = dataFlavorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DataFlavor df = dataFlavorArray[n2];
                    if (df.getRepresentationClass() == URL.class) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                Transferable t = support.getTransferable();
                try {
                    if (t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                        Image data = (Image)t.getTransferData(DataFlavor.imageFlavor);
                        JImageComponent.this.originalFile = null;
                        BufferedImage old = JImageComponent.this.image;
                        JImageComponent.this.image = new BufferedImage(data.getWidth(null), data.getHeight(null), 2);
                        JImageComponent.this.image.getGraphics().drawImage(data, 0, 0, null);
                        JImageComponent.this.reset();
                        JImageComponent.this.repaint();
                        JImageComponent.this.firePropertyChange("image", old, JImageComponent.this.image);
                        return true;
                    }
                    if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        List l = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                        if (l.size() == 1) {
                            BufferedImage oldImage = JImageComponent.this.image;
                            File oldFile = JImageComponent.this.originalFile;
                            JImageComponent.this.originalFile = (File)l.get(0);
                            JImageComponent.this.image = ImageIO.read(JImageComponent.this.originalFile);
                            JImageComponent.this.reset();
                            JImageComponent.this.repaint();
                            JImageComponent.this.firePropertyChange("image", oldImage, JImageComponent.this.image);
                            JImageComponent.this.firePropertyChange("file", oldFile, JImageComponent.this.originalFile);
                        }
                        return true;
                    }
                    DataFlavor[] dataFlavorArray = support.getDataFlavors();
                    int n = dataFlavorArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return true;
                        }
                        DataFlavor df = dataFlavorArray[n2];
                        if (df.getRepresentationClass() == URL.class) {
                            URL url = (URL)t.getTransferData(df);
                            JImageComponent.this.originalFile = null;
                            BufferedImage data = ImageIO.read(url);
                            if (data != null) {
                                BufferedImage old = JImageComponent.this.image;
                                JImageComponent.this.image = new BufferedImage(((Image)data).getWidth(null), ((Image)data).getHeight(null), 2);
                                JImageComponent.this.image.getGraphics().drawImage(data, 0, 0, null);
                                JImageComponent.this.reset();
                                JImageComponent.this.repaint();
                                JImageComponent.this.firePropertyChange("image", old, JImageComponent.this.image);
                                return true;
                            }
                        }
                        ++n2;
                    }
                }
                catch (Throwable thr) {
                    thr.printStackTrace();
                    return false;
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (JImageComponent.this.image == null) {
                    return;
                }
                if (!e.isPopupTrigger()) {
                    JImageComponent.this.lastDragPoint = e.getPoint();
                } else {
                    this.processPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.processPopup(e);
                } else {
                    if (JImageComponent.this.image == null) {
                        return;
                    }
                    if (!JImageComponent.this.isDragging) {
                        int xRel = e.getX();
                        int yRel = e.getY();
                        int xAbs = (int)((double)xRel / JImageComponent.this.zoom + JImageComponent.this.leftX);
                        int yAbs = (int)((double)yRel / JImageComponent.this.zoom + JImageComponent.this.topY);
                        if (xAbs >= 0 && xAbs < JImageComponent.this.image.getWidth() && yAbs >= 0 && yAbs < JImageComponent.this.image.getHeight()) {
                            JImageComponent.this.selectedColor = new Color(JImageComponent.this.image.getRGB(xAbs, yAbs));
                            JImageComponent.this.firePropertyChange("selectedColor", null, JImageComponent.this.selectedColor);
                        }
                    }
                    JImageComponent.this.isDragging = false;
                }
            }

            private void processPopup(MouseEvent e) {
                JPopupMenu editMenu = new JPopupMenu();
                editMenu.add(new AbstractAction("paste from clipboard"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                            DataFlavor[] flavors = clipboard.getAvailableDataFlavors();
                            if (flavors != null) {
                                DataFlavor[] dataFlavorArray = flavors;
                                int n = flavors.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    DataFlavor flavor = dataFlavorArray[n2];
                                    if (Image.class == flavor.getRepresentationClass()) {
                                        Image data = (Image)clipboard.getData(flavor);
                                        BufferedImage old = JImageComponent.this.image;
                                        JImageComponent.this.originalFile = null;
                                        JImageComponent.this.image = new BufferedImage(data.getWidth(null), data.getHeight(null), 2);
                                        JImageComponent.this.image.getGraphics().drawImage(data, 0, 0, null);
                                        JImageComponent.this.reset();
                                        JImageComponent.this.repaint();
                                        this.firePropertyChange("image", old, JImageComponent.this.image);
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                            JImageComponent.this.repaint();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }

                    @Override
                    public boolean isEnabled() {
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        DataFlavor[] flavors = clipboard.getAvailableDataFlavors();
                        if (flavors != null) {
                            DataFlavor[] dataFlavorArray = flavors;
                            int n = flavors.length;
                            int n2 = 0;
                            while (n2 < n) {
                                DataFlavor flavor = dataFlavorArray[n2];
                                if (Image.class == flavor.getRepresentationClass()) {
                                    return true;
                                }
                                ++n2;
                            }
                        }
                        return false;
                    }
                });
                Point pt = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), JImageComponent.this);
                editMenu.show(JImageComponent.this, pt.x, pt.y);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (JImageComponent.this.image == null) {
                    return;
                }
                JImageComponent.this.isDragging = true;
                Point currDragPoint = e.getPoint();
                double dx = (double)(currDragPoint.x - ((JImageComponent)JImageComponent.this).lastDragPoint.x) / JImageComponent.this.zoom;
                double dy = (double)(currDragPoint.y - ((JImageComponent)JImageComponent.this).lastDragPoint.y) / JImageComponent.this.zoom;
                JImageComponent jImageComponent = JImageComponent.this;
                jImageComponent.leftX = jImageComponent.leftX - dx;
                JImageComponent jImageComponent2 = JImageComponent.this;
                jImageComponent2.topY = jImageComponent2.topY - dy;
                JImageComponent.this.lastDragPoint = currDragPoint;
                JImageComponent.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (JImageComponent.this.image == null) {
                    return;
                }
                int xRel = e.getX();
                int yRel = e.getY();
                int xAbs = (int)((double)xRel / JImageComponent.this.zoom + JImageComponent.this.leftX);
                int yAbs = (int)((double)yRel / JImageComponent.this.zoom + JImageComponent.this.topY);
                if (xAbs >= 0 && xAbs < JImageComponent.this.image.getWidth() && yAbs >= 0 && yAbs < JImageComponent.this.image.getHeight()) {
                    Color old = JImageComponent.this.rolloverColor;
                    JImageComponent.this.rolloverColor = new Color(JImageComponent.this.image.getRGB(xAbs, yAbs));
                    JImageComponent.this.firePropertyChange("rolloverColor", old, JImageComponent.this.rolloverColor);
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                JImageComponent jImageComponent = JImageComponent.this;
                jImageComponent.zoom = jImageComponent.zoom + (double)(e.getScrollAmount() * e.getWheelRotation()) / 10.0;
                JImageComponent.this.zoom = Math.max(1.0, JImageComponent.this.zoom);
                JImageComponent.this.repaint();
            }
        });
        if (hasKeyboardZoom) {
            AbstractAction zoomInAction = new AbstractAction("zoomin"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JImageComponent jImageComponent = JImageComponent.this;
                    jImageComponent.zoom = jImageComponent.zoom + 0.1;
                    JImageComponent.this.repaint();
                }
            };
            AbstractAction zoomOutAction = new AbstractAction("zoomout"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JImageComponent jImageComponent = JImageComponent.this;
                    jImageComponent.zoom = jImageComponent.zoom - 0.1;
                    JImageComponent.this.zoom = Math.max(1.0, JImageComponent.this.zoom);
                    JImageComponent.this.repaint();
                }
            };
            ComponentInputMap inputMap = new ComponentInputMap(this);
            ((InputMap)inputMap).put(KeyStroke.getKeyStroke("I"), "zoomin");
            ((InputMap)inputMap).put(KeyStroke.getKeyStroke("O"), "zoomout");
            ActionMap actionMap = new ActionMap();
            actionMap.put("zoomin", zoomInAction);
            actionMap.put("zoomout", zoomOutAction);
            this.setInputMap(2, inputMap);
            this.setActionMap(actionMap);
        }
        this.setBorder(new SubstanceBorder());
        this.zoom = 1.0;
    }

    public void setLegend(String[] legend) {
        this.legend = legend;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image != null) {
            g2d.scale(this.zoom, this.zoom);
            g2d.translate(-this.leftX, -this.topY);
            g2d.drawImage((Image)this.image, 0, 0, null);
        } else {
            RenderingUtils.installDesktopHints((Graphics2D)g2d, (Component)this);
            g2d.setFont(UIManager.getFont("Label.font"));
            g2d.setColor(Color.black);
            int fh = g2d.getFontMetrics().getHeight();
            if (this.legend != null) {
                int i = 0;
                while (i < this.legend.length) {
                    g2d.drawString(this.legend[i], 10, 20 + i * fh);
                    ++i;
                }
            }
        }
        g2d.dispose();
    }

    private void reset() {
        this.leftX = 0.0;
        this.topY = 0.0;
        this.zoom = 1.0;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public File getOriginalFile() {
        return this.originalFile;
    }

    public Point toOriginalImageCoords(int x, int y) {
        int xAbs = (int)((double)x / this.zoom + this.leftX);
        int yAbs = (int)((double)y / this.zoom + this.topY);
        return new Point(xAbs, yAbs);
    }
}

