/*
 * Decompiled with CFR 0.152.
 */
package tools.electra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.FontUIResource;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import tools.common.JImageComponent;

public class JElectrifiedImageComponent
extends JComponent {
    private JImageComponent originalImageComponent;
    private BufferedImage originalImage;
    private static final int WIDTH = 500;
    private BufferedImage electrifiedImage;
    private float scaleFactor;
    private int imageOffsetX;
    private int imageOffsetY;
    private List<ZoomBubble> zoomBubbles = new ArrayList<ZoomBubble>();
    private JTextField captionEditor;
    private MouseDragHandler mouseDragHandler;
    private static final float RIM_THICKNESS = 3.0f;
    private static final float OUTER_SHADOW_THICKNESS = 8.0f;
    private static final float INNER_SHADOW_THICKNESS = 3.0f;
    private static final int TEXT_OUTER_SHADOW_THICKNESS = 6;

    public JElectrifiedImageComponent(JImageComponent originalImageComponent) {
        this.originalImageComponent = originalImageComponent;
        this.originalImageComponent.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                File file;
                File layers;
                if ("image".equals(evt.getPropertyName())) {
                    JElectrifiedImageComponent.this.originalImage = (BufferedImage)evt.getNewValue();
                    JElectrifiedImageComponent.this.reset();
                }
                if ("file".equals(evt.getPropertyName()) && (layers = new File((file = (File)evt.getNewValue()).getParent(), String.valueOf(file.getName()) + ".layers")).exists()) {
                    JElectrifiedImageComponent.this.loadBubbles(layers);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    JElectrifiedImageComponent.this.stopCaptionEdit(true);
                    for (ZoomBubble zoomBubble : JElectrifiedImageComponent.this.zoomBubbles) {
                        zoomBubble.isSelected = false;
                    }
                    BubbleDragPair pressed = JElectrifiedImageComponent.this.getInfoForDrag(e.getPoint());
                    if (pressed == null) {
                        JElectrifiedImageComponent.this.repaint();
                        return;
                    }
                    pressed.zoomBubble.isSelected = true;
                    switch (pressed.dragType) {
                        case BUBBLE_DRAG: {
                            JElectrifiedImageComponent.this.mouseDragHandler = new ZoomBubbleDragHandler(pressed.zoomBubble);
                            break;
                        }
                        case BUBBLE_RESIZE: {
                            JElectrifiedImageComponent.this.mouseDragHandler = new ZoomBubbleResizeHandler(pressed.zoomBubble);
                            break;
                        }
                        case CAPTION_DRAG: {
                            JElectrifiedImageComponent.this.mouseDragHandler = new ZoomBubbleCaptionDragHandler(pressed.zoomBubble);
                        }
                    }
                    JElectrifiedImageComponent.this.mouseDragHandler.onStart(e.getPoint());
                    JElectrifiedImageComponent.this.repaint();
                } else {
                    final BubbleDragPair pressed = JElectrifiedImageComponent.this.getInfoForDrag(e.getPoint());
                    if (pressed == null) {
                        return;
                    }
                    JPopupMenu popupMenu = new JPopupMenu();
                    popupMenu.add(new AbstractAction("remove"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            JElectrifiedImageComponent.this.zoomBubbles.remove(pressed.zoomBubble);
                            JElectrifiedImageComponent.this.repaint();
                        }
                    });
                    popupMenu.add(new AbstractAction("invert caption colors"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            pressed.zoomBubble.isInverted = !pressed.zoomBubble.isInverted;
                            JElectrifiedImageComponent.this.repaint();
                        }
                    });
                    Point pt = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), JElectrifiedImageComponent.this);
                    popupMenu.show(JElectrifiedImageComponent.this, pt.x, pt.y);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                for (ZoomBubble zoomBubble : JElectrifiedImageComponent.this.zoomBubbles) {
                    if (!zoomBubble.isSelected || zoomBubble.caption != null) continue;
                    zoomBubble.captionOffsetX = zoomBubble.centerX < (double)(JElectrifiedImageComponent.this.originalImage.getWidth() / 2) ? zoomBubble.radius + 30.0 : -zoomBubble.radius - 30.0;
                    zoomBubble.captionOffsetY = 0.0;
                    JElectrifiedImageComponent.this.startCaptionEdit(zoomBubble);
                    return;
                }
                for (ZoomBubble zoomBubble : JElectrifiedImageComponent.this.zoomBubbles) {
                    if (zoomBubble.captionRectangle == null || !zoomBubble.captionRectangle.contains(e.getPoint())) continue;
                    JElectrifiedImageComponent.this.startCaptionEdit(zoomBubble);
                    break;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (JElectrifiedImageComponent.this.mouseDragHandler != null) {
                    JElectrifiedImageComponent.this.mouseDragHandler.onEnd(e.getPoint());
                    JElectrifiedImageComponent.this.mouseDragHandler = null;
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (JElectrifiedImageComponent.this.mouseDragHandler != null) {
                    JElectrifiedImageComponent.this.mouseDragHandler.onDrag(e.getPoint());
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                BubbleDragPair underMouse = JElectrifiedImageComponent.this.getInfoForDrag(e.getPoint());
                if (underMouse == null) {
                    JElectrifiedImageComponent.this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                switch (underMouse.dragType) {
                    case BUBBLE_DRAG: 
                    case CAPTION_DRAG: {
                        JElectrifiedImageComponent.this.setCursor(Cursor.getPredefinedCursor(12));
                        break;
                    }
                    case BUBBLE_RESIZE: {
                        JElectrifiedImageComponent.this.setCursor(Cursor.getPredefinedCursor(9));
                    }
                }
            }
        });
        this.captionEditor = new JTextField(25);
        InputMap im = this.captionEditor.getInputMap();
        im.put(KeyStroke.getKeyStroke(10, 0), "enter");
        im.put(KeyStroke.getKeyStroke(27, 0), "escape");
        ActionMap am = this.captionEditor.getActionMap();
        am.put("enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JElectrifiedImageComponent.this.stopCaptionEdit(true);
            }
        });
        am.put("escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JElectrifiedImageComponent.this.stopCaptionEdit(false);
            }
        });
        this.captionEditor.setVisible(false);
        this.add(this.captionEditor);
        this.setLayout(null);
    }

    BubbleDragPair getInfoForDrag(Point viewPoint) {
        for (ZoomBubble zoomBubble : this.zoomBubbles) {
            double diffY;
            Point2D zoomViewCenter = this.originalToView(new Point2D.Double(zoomBubble.centerX, zoomBubble.centerY));
            double diffX = zoomViewCenter.getX() - (double)viewPoint.x;
            double distFromCenter = Math.sqrt(diffX * diffX + (diffY = zoomViewCenter.getY() - (double)viewPoint.y) * diffY);
            if (distFromCenter < zoomBubble.radius / 2.0) {
                return new BubbleDragPair(zoomBubble, DragType.BUBBLE_DRAG);
            }
            if (!(distFromCenter < zoomBubble.radius)) continue;
            return new BubbleDragPair(zoomBubble, DragType.BUBBLE_RESIZE);
        }
        for (ZoomBubble zoomBubble : this.zoomBubbles) {
            if (zoomBubble.captionRectangle == null || !zoomBubble.captionRectangle.contains(viewPoint)) continue;
            return new BubbleDragPair(zoomBubble, DragType.CAPTION_DRAG);
        }
        return null;
    }

    static BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        int w = img.getWidth();
        int h = img.getHeight();
        do {
            if (w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }

    private void reset() {
        if (this.originalImage == null) {
            this.electrifiedImage = null;
        } else {
            this.scaleFactor = 500.0f / (float)this.originalImage.getWidth();
            if (this.scaleFactor < 1.0f) {
                this.electrifiedImage = JElectrifiedImageComponent.getScaledInstance(this.originalImage, 500, (int)(this.scaleFactor * (float)this.originalImage.getHeight()));
            } else {
                this.scaleFactor = 1.0f;
                this.electrifiedImage = this.originalImage;
            }
            int kernelSide = 3;
            float[] kernelData = new float[kernelSide * kernelSide];
            int i = 0;
            while (i < kernelData.length) {
                kernelData[i] = 1.0f / (float)kernelData.length;
                ++i;
            }
            Kernel kernel = new Kernel(kernelSide, kernelSide, kernelData);
            this.electrifiedImage = new ConvolveOp(kernel, 1, null).filter(this.electrifiedImage, null);
            this.setPreferredSize(new Dimension(this.getSize().width, this.electrifiedImage.getHeight() + 50));
            ((JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this)).revalidate();
        }
        this.zoomBubbles.clear();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        if (this.electrifiedImage != null) {
            int width = this.getWidth();
            int height = this.getHeight();
            this.imageOffsetX = (width - this.electrifiedImage.getWidth()) / 2;
            this.imageOffsetY = (height - this.electrifiedImage.getHeight()) / 2;
            this.paintElectrified(g2d, true, this.imageOffsetX, this.imageOffsetY);
        }
        g2d.dispose();
    }

    private void paintElectrified(Graphics2D g2d, boolean isOnScreen, int offsetX, int offsetY) {
        if (this.electrifiedImage != null) {
            g2d.drawImage((Image)this.electrifiedImage, offsetX, offsetY, null);
            g2d.setColor(new Color(0, 0, 0, 32));
            g2d.fillRect(offsetX, offsetY, this.electrifiedImage.getWidth(), this.electrifiedImage.getHeight());
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (ZoomBubble zoomBubble : this.zoomBubbles) {
                double bubbleCenterViewX = (double)offsetX + zoomBubble.centerX * (double)this.scaleFactor;
                double bubbleCenterViewY = (double)offsetY + zoomBubble.centerY * (double)this.scaleFactor;
                Shape currClip = g2d.getClip();
                int centerViewX = (int)bubbleCenterViewX;
                int centerViewY = (int)bubbleCenterViewY;
                g2d.clip(new Ellipse2D.Double((double)centerViewX - zoomBubble.radius, (double)centerViewY - zoomBubble.radius, 2.0 * zoomBubble.radius, 2.0 * zoomBubble.radius));
                int sx1 = (int)(zoomBubble.centerX - zoomBubble.radius);
                int dx1 = (int)((double)centerViewX - zoomBubble.radius);
                int sx2 = (int)(zoomBubble.centerX + zoomBubble.radius);
                int dx2 = dx1 + (sx2 - sx1);
                if (sx1 < 0) {
                    dx1 -= sx1;
                    sx1 = 0;
                }
                if (sx2 > this.originalImage.getWidth()) {
                    dx2 -= sx2 - this.originalImage.getWidth();
                    sx2 = this.originalImage.getWidth();
                }
                int sy1 = (int)(zoomBubble.centerY - zoomBubble.radius);
                int dy1 = (int)((double)centerViewY - zoomBubble.radius);
                int sy2 = (int)(zoomBubble.centerY + zoomBubble.radius);
                int dy2 = dy1 + (sy2 - sy1);
                if (sy1 < 0) {
                    dy1 -= sy1;
                    sy1 = 0;
                }
                if (sy2 > this.originalImage.getHeight()) {
                    dy2 -= sy2 - this.originalImage.getHeight();
                    sy2 = this.originalImage.getHeight();
                }
                if (sx2 - sx1 != dx2 - dx1) {
                    throw new IllegalStateException();
                }
                if (sy2 - sy1 != dy2 - dy1) {
                    throw new IllegalStateException();
                }
                g2d.drawImage(this.originalImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
                g2d.setClip(currClip);
                float totalRadius = (float)(zoomBubble.radius + 1.5 + 8.0);
                RadialGradientPaint rimPaint = new RadialGradientPaint(centerViewX, (float)centerViewY, totalRadius, new float[]{0.0f, (float)((zoomBubble.radius - 1.5 - 3.0) / (double)totalRadius), (float)((zoomBubble.radius - 1.5) / (double)totalRadius), (float)((zoomBubble.radius + 1.5) / (double)totalRadius), (float)((zoomBubble.radius + 1.5 + 2.6666667461395264) / (double)totalRadius), 1.0f}, new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 128), new Color(0, 0, 0, 128), new Color(0, 0, 0, 32), new Color(0, 0, 0, 0)});
                g2d.setPaint(rimPaint);
                g2d.fill(new Ellipse2D.Double((float)centerViewX - totalRadius, (float)centerViewY - totalRadius, 2.0f * totalRadius, 2.0f * totalRadius));
                g2d.setColor(Color.white);
                g2d.setStroke(new BasicStroke(3.0f));
                g2d.draw(new Ellipse2D.Double((double)centerViewX - zoomBubble.radius, (double)centerViewY - zoomBubble.radius, 2.0 * zoomBubble.radius, 2.0 * zoomBubble.radius));
                if (zoomBubble.isSelected && isOnScreen) {
                    g2d.setColor(new Color(0, 0, 0, 196));
                    int selectionCornerSide = 6;
                    int selectionLeftX = (int)((double)centerViewX - zoomBubble.radius - 1.5);
                    int selectionRightX = (int)((double)centerViewX + zoomBubble.radius + 1.5);
                    int selectionTopY = (int)((double)centerViewY - zoomBubble.radius - 1.5);
                    int selectionBottomY = (int)((double)centerViewY + zoomBubble.radius + 1.5);
                    g2d.setStroke(new BasicStroke(1.2f));
                    g2d.drawRect(selectionLeftX - selectionCornerSide / 2, selectionTopY - selectionCornerSide / 2, selectionCornerSide, selectionCornerSide);
                    g2d.drawRect(selectionLeftX - selectionCornerSide / 2, selectionBottomY - selectionCornerSide / 2, selectionCornerSide, selectionCornerSide);
                    g2d.drawRect(selectionRightX - selectionCornerSide / 2, selectionTopY - selectionCornerSide / 2, selectionCornerSide, selectionCornerSide);
                    g2d.drawRect(selectionRightX - selectionCornerSide / 2, selectionBottomY - selectionCornerSide / 2, selectionCornerSide, selectionCornerSide);
                    g2d.setStroke(new BasicStroke(1.2f, 0, 1, 0.0f, new float[]{2.0f, 1.0f}, 0.0f));
                    g2d.drawLine(selectionLeftX + selectionCornerSide / 2, selectionTopY, selectionRightX - selectionCornerSide / 2, selectionTopY);
                    g2d.drawLine(selectionLeftX + selectionCornerSide / 2, selectionBottomY, selectionRightX - selectionCornerSide / 2, selectionBottomY);
                    g2d.drawLine(selectionLeftX, selectionTopY + selectionCornerSide / 2, selectionLeftX, selectionBottomY - selectionCornerSide / 2);
                    g2d.drawLine(selectionRightX, selectionTopY + selectionCornerSide / 2, selectionRightX, selectionBottomY - selectionCornerSide / 2);
                }
                if (zoomBubble.caption == null || zoomBubble.isInTextEdit) continue;
                FontUIResource font = SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null).getControlFont();
                g2d.setFont(font);
                int strWidth = g2d.getFontMetrics().stringWidth(zoomBubble.caption);
                int fontHeight = g2d.getFontMetrics().getHeight();
                int captionHeight = fontHeight + 8;
                int captionWidth = strWidth + 8;
                int radius = 3;
                int x = (int)((double)centerViewX + zoomBubble.captionOffsetX);
                int y = (int)((double)centerViewY + zoomBubble.captionOffsetY);
                Shape outerContour = zoomBubble.captionOffsetX < 0.0 ? this.getCaptionOutlinePointingToRight(captionHeight, captionWidth, radius, 0) : this.getCaptionOutlinePointingToLeft(captionHeight, captionWidth, radius, 0);
                Shape innerContour = zoomBubble.captionOffsetX < 0.0 ? this.getCaptionOutlinePointingToRight(captionHeight, captionWidth, radius, 1) : this.getCaptionOutlinePointingToLeft(captionHeight, captionWidth, radius, 1);
                boolean isInverted = zoomBubble.isInverted;
                g2d.translate(x, y);
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, isInverted ? new Color(224, 224, 224, 240) : new Color(32, 32, 32, 240), 0.0f, captionHeight, isInverted ? new Color(255, 255, 255, 240) : new Color(0, 0, 0, 240)));
                g2d.fill(outerContour);
                int i = 6;
                while (i >= 0) {
                    g2d.setColor(new Color(0, 0, 0, 12));
                    g2d.setStroke(new BasicStroke(i));
                    g2d.draw(outerContour);
                    --i;
                }
                g2d.setColor(isInverted ? new Color(255, 255, 255, 196) : new Color(0, 0, 0, 196));
                g2d.setStroke(new BasicStroke(1.0f, 0, 0));
                g2d.draw(outerContour);
                g2d.setPaint(new LinearGradientPaint(0.0f, 0.0f, 0.0f, captionHeight, new float[]{0.0f, 0.8f, 1.0f}, new Color[]{isInverted ? new Color(64, 64, 64, 64) : new Color(192, 192, 192, 64), isInverted ? new Color(64, 64, 64, 48) : new Color(192, 192, 192, 48), isInverted ? new Color(64, 64, 64, 16) : new Color(192, 192, 192, 16)}));
                g2d.setStroke(new BasicStroke(1.0f, 0, 0));
                g2d.draw(innerContour);
                g2d.translate(-x, -y);
                RenderingUtils.installDesktopHints((Graphics2D)g2d, (Component)this);
                int textY = y + 4 + g2d.getFontMetrics().getAscent();
                int textX = zoomBubble.captionOffsetX < 0.0 ? x + captionHeight / 6 + 4 : x + captionHeight / 3 + 4;
                g2d.setColor(isInverted ? new Color(255, 255, 255, 128) : new Color(0, 0, 0, 196));
                g2d.drawString(zoomBubble.caption, textX - 1, textY);
                g2d.drawString(zoomBubble.caption, textX + 1, textY);
                g2d.drawString(zoomBubble.caption, textX, textY - 1);
                g2d.drawString(zoomBubble.caption, textX, textY + 1);
                g2d.setColor(isInverted ? new Color(0, 0, 0) : new Color(224, 224, 224));
                g2d.drawString(zoomBubble.caption, textX, textY);
                zoomBubble.captionRectangle = zoomBubble.captionOffsetX < 0.0 ? new Rectangle(x + captionHeight / 6, y, captionWidth, captionHeight) : new Rectangle(x + captionHeight / 3, y, captionWidth, captionHeight);
            }
        }
    }

    private Shape getCaptionOutlinePointingToRight(int captionHeight, int captionWidth, int radius, int insets) {
        GeneralPath contour = new GeneralPath();
        contour.moveTo(radius, insets);
        contour.lineTo(captionWidth, insets);
        contour.lineTo(captionWidth + captionHeight / 2 - insets, captionHeight / 2);
        contour.lineTo(captionWidth, captionHeight - insets);
        contour.append(new Arc2D.Double(insets, captionHeight - 2 * radius + insets, 2 * radius - 2 * insets, 2 * radius - 2 * insets, 270.0, -90.0, 0), true);
        contour.lineTo(insets, radius);
        contour.append(new Arc2D.Double(insets, insets, 2 * radius - 2 * insets, 2 * radius - 2 * insets, 180.0, -90.0, 0), true);
        contour.closePath();
        return contour;
    }

    private Shape getCaptionOutlinePointingToLeft(int captionHeight, int captionWidth, int radius, int insets) {
        GeneralPath contour = new GeneralPath();
        contour.moveTo(insets, captionHeight / 2);
        contour.lineTo(captionHeight / 2, insets);
        contour.lineTo(captionWidth + captionHeight / 2 - radius, insets);
        contour.append(new Arc2D.Double(captionWidth + captionHeight / 2 - 2 * radius + insets, insets, 2 * radius - 2 * insets, 2 * radius - 2 * insets, 90.0, -90.0, 0), true);
        contour.lineTo(captionWidth + captionHeight / 2 - insets, captionHeight - radius - insets);
        contour.append(new Arc2D.Double(captionWidth + captionHeight / 2 - 2 * radius + insets, captionHeight - 2 * radius + insets, 2 * radius - 2 * insets, 2 * radius - 2 * insets, 0.0, -90.0, 0), true);
        contour.lineTo(captionHeight / 2, captionHeight - insets);
        contour.closePath();
        return contour;
    }

    void addZoomBubble(int x, int y, int radius) {
        ZoomBubble zoomBubble = new ZoomBubble();
        zoomBubble.centerX = x;
        zoomBubble.centerY = y;
        zoomBubble.radius = radius;
        zoomBubble.isInverted = false;
        this.zoomBubbles.add(zoomBubble);
        this.repaint();
    }

    Point2D originalToView(Point2D original) {
        double viewX = (double)this.imageOffsetX + original.getX() * (double)this.scaleFactor;
        double viewY = (double)this.imageOffsetY + original.getY() * (double)this.scaleFactor;
        return new Point2D.Double(viewX, viewY);
    }

    Point2D viewToOriginal(Point2D view) {
        double origX = (view.getX() - (double)this.imageOffsetX) / (double)this.scaleFactor;
        double origY = (view.getY() - (double)this.imageOffsetY) / (double)this.scaleFactor;
        return new Point2D.Double(origX, origY);
    }

    void startCaptionEdit(ZoomBubble bubble) {
        bubble.isInTextEdit = true;
        if (bubble.caption != null) {
            this.captionEditor.setText(bubble.caption);
            this.captionEditor.selectAll();
        } else {
            this.captionEditor.setText("");
        }
        Dimension pref = this.captionEditor.getPreferredSize();
        Point2D bubbleCenterView = this.originalToView(new Point2D.Double(bubble.centerX, bubble.centerY));
        this.captionEditor.setBounds((int)(bubbleCenterView.getX() + bubble.captionOffsetX), (int)(bubbleCenterView.getY() + bubble.captionOffsetY), pref.width, pref.height);
        this.captionEditor.setVisible(true);
        this.captionEditor.requestFocus();
        this.repaint();
    }

    void stopCaptionEdit(boolean saveChanges) {
        if (!this.captionEditor.isVisible()) {
            return;
        }
        String text = this.captionEditor.getText();
        if (text.length() == 0) {
            text = null;
        }
        for (ZoomBubble zoomBubble : this.zoomBubbles) {
            if (!zoomBubble.isInTextEdit) continue;
            zoomBubble.caption = text;
            zoomBubble.isInTextEdit = false;
        }
        this.captionEditor.setVisible(false);
        this.repaint();
    }

    void save(File originalFile) {
        int extraTop = 0;
        int extraBottom = 0;
        int extraLeft = 0;
        int extraRight = 0;
        for (ZoomBubble zoomBubble : this.zoomBubbles) {
            Point2D bubbleCenterView = this.originalToView(new Point2D.Double(zoomBubble.centerX, zoomBubble.centerY));
            double l = bubbleCenterView.getX() - zoomBubble.radius - (double)this.imageOffsetX - 1.5 - 8.0;
            double r = bubbleCenterView.getX() + zoomBubble.radius - (double)this.imageOffsetX + 1.5 + 8.0;
            double t = bubbleCenterView.getY() - zoomBubble.radius - (double)this.imageOffsetY - 1.5 - 8.0;
            double b = bubbleCenterView.getY() + zoomBubble.radius - (double)this.imageOffsetY + 1.5 + 8.0;
            if (zoomBubble.captionRectangle != null) {
                l = Math.min(l, zoomBubble.captionRectangle.getMinX() - (double)this.imageOffsetX - 6.0);
                r = Math.max(r, zoomBubble.captionRectangle.getMaxX() - (double)this.imageOffsetX + 6.0);
                t = Math.min(t, zoomBubble.captionRectangle.getMinY() - (double)this.imageOffsetY - 6.0);
                b = Math.max(b, zoomBubble.captionRectangle.getMaxY() - (double)this.imageOffsetY + 6.0);
            }
            if (l < 0.0) {
                extraLeft = Math.max(extraLeft, (int)Math.ceil(-l));
            }
            if (r > 500.0) {
                extraRight = Math.max(extraRight, (int)Math.ceil(r - 500.0));
            }
            if (t < 0.0) {
                extraTop = Math.max(extraTop, (int)Math.ceil(-t));
            }
            if (!(b > (double)this.electrifiedImage.getHeight())) continue;
            extraBottom = Math.max(extraBottom, (int)Math.ceil(b - (double)this.electrifiedImage.getHeight()));
        }
        int finalWidth = 500 + extraLeft + extraRight;
        int finalHeight = this.electrifiedImage.getHeight() + extraTop + extraBottom;
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        BufferedImage compatibleImage = c.createCompatibleImage(finalWidth, finalHeight, 3);
        Graphics2D g2d = compatibleImage.createGraphics();
        g2d.translate(extraLeft, extraTop);
        this.paintElectrified(g2d, false, 0, 0);
        g2d.dispose();
        try {
            String origFileName = originalFile.getName();
            String targetFileName = String.valueOf(origFileName.substring(0, origFileName.lastIndexOf(46))) + ".electra.png";
            ImageIO.write((RenderedImage)compatibleImage, "png", new File(originalFile.getParentFile(), targetFileName));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.saveBubbles(new File(originalFile.getParentFile(), String.valueOf(originalFile.getName()) + ".layers"));
    }

    private void saveBubbles(File file) {
        try {
            PrintWriter pw = new PrintWriter(file);
            pw.println("count=" + this.zoomBubbles.size());
            int i = 0;
            while (i < this.zoomBubbles.size()) {
                ZoomBubble zoomBubble = this.zoomBubbles.get(i);
                pw.println("bubble" + i + ".centerX=" + zoomBubble.centerX);
                pw.println("bubble" + i + ".centerY=" + zoomBubble.centerY);
                pw.println("bubble" + i + ".radius=" + zoomBubble.radius);
                if (zoomBubble.caption != null) {
                    pw.println("bubble" + i + ".caption=" + zoomBubble.caption);
                    pw.println("bubble" + i + ".captionOffsetX=" + zoomBubble.captionOffsetX);
                    pw.println("bubble" + i + ".captionOffsetY=" + zoomBubble.captionOffsetY);
                }
                pw.println("bubble" + i + ".isInverted=" + zoomBubble.isInverted);
                ++i;
            }
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadBubbles(File file) {
        try {
            Properties props = new Properties();
            props.load(new FileReader(file));
            this.zoomBubbles.clear();
            int count = Integer.parseInt(props.getProperty("count"));
            int i = 0;
            while (i < count) {
                String invertedKey;
                ZoomBubble zoomBubble = new ZoomBubble();
                zoomBubble.centerX = Double.parseDouble(props.getProperty("bubble" + i + ".centerX"));
                zoomBubble.centerY = Double.parseDouble(props.getProperty("bubble" + i + ".centerY"));
                zoomBubble.radius = Double.parseDouble(props.getProperty("bubble" + i + ".radius"));
                zoomBubble.caption = props.getProperty("bubble" + i + ".caption");
                if (zoomBubble.caption != null) {
                    zoomBubble.captionOffsetX = Double.parseDouble(props.getProperty("bubble" + i + ".captionOffsetX"));
                    zoomBubble.captionOffsetY = Double.parseDouble(props.getProperty("bubble" + i + ".captionOffsetY"));
                }
                zoomBubble.isInverted = props.containsKey(invertedKey = "bubble" + i + ".isInverted") ? Boolean.parseBoolean(props.getProperty(invertedKey)) : false;
                this.zoomBubbles.add(zoomBubble);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class BubbleDragPair {
        ZoomBubble zoomBubble;
        DragType dragType;

        public BubbleDragPair(ZoomBubble zoomBubble, DragType dragType) {
            this.zoomBubble = zoomBubble;
            this.dragType = dragType;
        }
    }

    private static enum DragType {
        BUBBLE_DRAG,
        BUBBLE_RESIZE,
        CAPTION_DRAG;

    }

    private static interface MouseDragHandler {
        public void onStart(Point var1);

        public void onDrag(Point var1);

        public void onEnd(Point var1);
    }

    private static class ZoomBubble {
        double centerX;
        double centerY;
        double radius;
        boolean isSelected;
        boolean isInTextEdit;
        String caption;
        double captionOffsetX;
        double captionOffsetY;
        Rectangle captionRectangle;
        boolean isInverted;

        private ZoomBubble() {
        }
    }

    private class ZoomBubbleCaptionDragHandler
    implements MouseDragHandler {
        private ZoomBubble zoomBubble;
        private Point lastDragPoint;

        public ZoomBubbleCaptionDragHandler(ZoomBubble zoomBubble) {
            this.zoomBubble = zoomBubble;
        }

        @Override
        public void onStart(Point point) {
            this.lastDragPoint = point;
        }

        @Override
        public void onDrag(Point point) {
            int dx = point.x - this.lastDragPoint.x;
            int dy = point.y - this.lastDragPoint.y;
            this.zoomBubble.captionOffsetX += (double)dx;
            this.zoomBubble.captionOffsetY += (double)dy;
            this.lastDragPoint = point;
            JElectrifiedImageComponent.this.repaint();
        }

        @Override
        public void onEnd(Point point) {
        }
    }

    private class ZoomBubbleDragHandler
    implements MouseDragHandler {
        private ZoomBubble zoomBubble;
        private Point lastDragPoint;

        public ZoomBubbleDragHandler(ZoomBubble zoomBubble) {
            this.zoomBubble = zoomBubble;
        }

        @Override
        public void onStart(Point point) {
            this.lastDragPoint = point;
        }

        @Override
        public void onDrag(Point point) {
            double dx = (float)(point.x - this.lastDragPoint.x) / JElectrifiedImageComponent.this.scaleFactor;
            double dy = (float)(point.y - this.lastDragPoint.y) / JElectrifiedImageComponent.this.scaleFactor;
            this.zoomBubble.centerX += dx;
            this.zoomBubble.centerY += dy;
            this.lastDragPoint = point;
            JElectrifiedImageComponent.this.repaint();
        }

        @Override
        public void onEnd(Point point) {
        }
    }

    private class ZoomBubbleResizeHandler
    implements MouseDragHandler {
        private ZoomBubble zoomBubble;
        private Point lastDragPoint;

        public ZoomBubbleResizeHandler(ZoomBubble zoomBubble) {
            this.zoomBubble = zoomBubble;
        }

        @Override
        public void onStart(Point point) {
            this.lastDragPoint = point;
        }

        @Override
        public void onDrag(Point point) {
            Point2D bubbleCenterView = JElectrifiedImageComponent.this.originalToView(new Point2D.Double(this.zoomBubble.centerX, this.zoomBubble.centerY));
            double ndx = (double)point.x - bubbleCenterView.getX();
            double ndy = (double)point.y - bubbleCenterView.getY();
            double newRadius = Math.sqrt(ndx * ndx + ndy * ndy);
            double odx = (double)this.lastDragPoint.x - bubbleCenterView.getX();
            double ody = (double)this.lastDragPoint.y - bubbleCenterView.getY();
            double oldRadius = Math.sqrt(odx * odx + ody * ody);
            this.zoomBubble.radius += newRadius - oldRadius;
            this.lastDragPoint = point;
            JElectrifiedImageComponent.this.repaint();
        }

        @Override
        public void onEnd(Point point) {
        }
    }
}

