/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven.bootstrap;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.Proxy;
import org.sonarsource.scanner.api.EmbeddedScanner;
import org.sonarsource.scanner.api.LogOutput;
import org.sonarsource.scanner.maven.bootstrap.MavenUtils;
import org.sonarsource.scanner.maven.bootstrap.PropertyDecryptor;

public class ScannerFactory {
    private static final String UNKNOWN_PROXY_PROTOCOL_MESSAGE = "Setting proxy properties: one or multiple protocols of the active proxy (id: %s) are not supported (protocols: %s).";
    private final LogOutput logOutput;
    private final RuntimeInformation runtimeInformation;
    private final MavenSession session;
    private final boolean debugEnabled;
    private final PropertyDecryptor propertyDecryptor;
    private final Properties envProps;
    private final Log log;
    private final MojoExecution mojoExecution;

    public ScannerFactory(LogOutput logOutput, Log log, RuntimeInformation runtimeInformation, MojoExecution mojoExecution, MavenSession session, Properties envProps, PropertyDecryptor propertyDecryptor) {
        this.logOutput = logOutput;
        this.log = log;
        this.runtimeInformation = runtimeInformation;
        this.mojoExecution = mojoExecution;
        this.session = session;
        this.debugEnabled = log.isDebugEnabled();
        this.envProps = envProps;
        this.propertyDecryptor = propertyDecryptor;
    }

    public EmbeddedScanner create() {
        this.setProxySystemProperties();
        EmbeddedScanner scanner = EmbeddedScanner.create((String)"ScannerMaven", (String)(this.mojoExecution.getVersion() + "/" + this.runtimeInformation.getMavenVersion()), (LogOutput)this.logOutput);
        scanner.addGlobalProperties(this.createGlobalProperties());
        if (this.debugEnabled) {
            scanner.setGlobalProperty("sonar.verbose", "true");
        }
        return scanner;
    }

    public Map<String, String> createGlobalProperties() {
        HashMap<String, String> p = new HashMap<String, String>();
        MavenUtils.putAll(this.session.getCurrentProject().getProperties(), p);
        MavenUtils.putAll(this.envProps, p);
        MavenUtils.putAll(this.session.getSystemProperties(), p);
        MavenUtils.putAll(this.session.getUserProperties(), p);
        p.putAll(this.propertyDecryptor.decryptProperties(p));
        return p;
    }

    public void setProxySystemProperties() {
        Proxy activeProxy = this.session.getSettings().getActiveProxy();
        if (activeProxy == null) {
            this.log.debug((CharSequence)"Skipping proxy settings: No active proxy detected.");
            return;
        }
        String protocol = activeProxy.getProtocol();
        if (protocol == null) {
            this.log.warn((CharSequence)("Skipping proxy settings: an active proxy was detected (id: " + activeProxy.getId() + ") but the protocol is null."));
            return;
        }
        Set protocols = Arrays.stream(activeProxy.getProtocol().trim().split("\\|")).map(proto -> proto.trim().toLowerCase(Locale.ROOT)).filter(proto -> !proto.isEmpty()).collect(Collectors.toSet());
        if (protocols.isEmpty()) {
            this.log.warn((CharSequence)("Skipping proxy settings: an active proxy was detected (id: " + activeProxy.getId() + ") but the protocol was not recognized."));
            return;
        }
        this.log.debug((CharSequence)"Setting proxy properties");
        if (protocols.remove("http")) {
            System.setProperty("http.proxyHost", activeProxy.getHost());
            System.setProperty("http.proxyPort", String.valueOf(activeProxy.getPort()));
            ScannerFactory.setCommonHttpProperties(activeProxy);
        }
        if (protocols.remove("https")) {
            System.setProperty("https.proxyHost", activeProxy.getHost());
            System.setProperty("https.proxyPort", String.valueOf(activeProxy.getPort()));
            ScannerFactory.setCommonHttpProperties(activeProxy);
        }
        if (!protocols.isEmpty()) {
            String remainingProtocols = String.join((CharSequence)", ", protocols);
            this.log.warn((CharSequence)String.format(UNKNOWN_PROXY_PROTOCOL_MESSAGE, activeProxy.getId(), remainingProtocols));
        }
    }

    private static void setCommonHttpProperties(Proxy proxy) {
        System.setProperty("http.proxyUser", StringUtils.defaultString((String)proxy.getUsername(), (String)""));
        System.setProperty("http.proxyPassword", StringUtils.defaultString((String)proxy.getPassword(), (String)""));
        System.setProperty("http.nonProxyHosts", StringUtils.defaultString((String)proxy.getNonProxyHosts(), (String)""));
    }
}

