/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.convert.threeten;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.springframework.data.convert.Jsr310Converters;

public class Jsr310JpaConverters {

    @Converter(autoApply=true)
    public static class InstantConverter
    implements AttributeConverter<Instant, Date> {
        public Date convertToDatabaseColumn(Instant instant) {
            return Jsr310Converters.InstantToDateConverter.INSTANCE.convert(instant);
        }

        public Instant convertToEntityAttribute(Date date) {
            return Jsr310Converters.DateToInstantConverter.INSTANCE.convert(date);
        }
    }

    @Converter(autoApply=true)
    public static class LocalDateTimeConverter
    implements AttributeConverter<LocalDateTime, Date> {
        public Date convertToDatabaseColumn(LocalDateTime date) {
            return Jsr310Converters.LocalDateTimeToDateConverter.INSTANCE.convert(date);
        }

        public LocalDateTime convertToEntityAttribute(Date date) {
            return Jsr310Converters.DateToLocalDateTimeConverter.INSTANCE.convert(date);
        }
    }

    @Converter(autoApply=true)
    public static class LocalTimeConverter
    implements AttributeConverter<LocalTime, Date> {
        public Date convertToDatabaseColumn(LocalTime time) {
            return Jsr310Converters.LocalTimeToDateConverter.INSTANCE.convert(time);
        }

        public LocalTime convertToEntityAttribute(Date date) {
            return Jsr310Converters.DateToLocalTimeConverter.INSTANCE.convert(date);
        }
    }

    @Converter(autoApply=true)
    public static class LocalDateConverter
    implements AttributeConverter<LocalDate, Date> {
        public Date convertToDatabaseColumn(LocalDate date) {
            return Jsr310Converters.LocalDateToDateConverter.INSTANCE.convert(date);
        }

        public LocalDate convertToEntityAttribute(Date date) {
            return Jsr310Converters.DateToLocalDateConverter.INSTANCE.convert(date);
        }
    }
}

