/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aesh.command.CommandException;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.CommandRuntime;
import org.aesh.command.Executor;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationConfiguration;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.shell.Shell;
import org.aesh.command.validator.CommandValidatorException;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.readline.AeshContext;
import org.aesh.readline.Prompt;
import org.aesh.readline.action.KeyAction;
import org.aesh.readline.completion.Completion;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.ReadlineConsole;
import org.jboss.as.cli.impl.aesh.CLICommandRegistry;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;

class CLICommandInvocationImpl
implements CLICommandInvocation {
    private final CommandContext ctx;
    private final CLICommandRegistry registry;
    private final Shell shell;
    private final ReadlineConsole console;
    private final CommandInvocationConfiguration config;
    private final CommandRuntime runtime;

    CLICommandInvocationImpl(CommandContext ctx, CLICommandRegistry registry, ReadlineConsole console, Shell shell, CommandRuntime runtime, CommandInvocationConfiguration config) {
        this.ctx = ctx;
        this.registry = registry;
        this.console = console;
        this.shell = shell;
        this.runtime = runtime;
        this.config = config;
    }

    @Override
    public CommandContext getCommandContext() {
        return this.ctx;
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setPrompt(Prompt prompt) {
        if (this.console != null) {
            this.console.setPrompt(prompt);
        }
    }

    public Prompt getPrompt() {
        if (this.console != null) {
            return this.console.getPrompt();
        }
        return null;
    }

    public String getHelpInfo(String commandName) {
        try {
            CommandLineParser parser = this.registry.findCommand(commandName, commandName);
            if (parser != null) {
                return parser.printHelp();
            }
        }
        catch (CommandNotFoundException ex) {
            Logger.getLogger(CLICommandInvocationImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        return "";
    }

    public void stop() {
        this.ctx.terminateSession();
    }

    public AeshContext getAeshContext() {
        return this.config.getAeshContext();
    }

    public KeyAction input() throws InterruptedException {
        return this.shell.read();
    }

    public String inputLine() throws InterruptedException {
        return this.inputLine(new Prompt(""));
    }

    public String inputLine(Prompt prompt) throws InterruptedException {
        return this.shell.readLine(prompt);
    }

    public void executeCommand(String input) throws CommandNotFoundException, CommandLineParserException, OptionValidatorException, CommandValidatorException, CommandException, InterruptedException, IOException {
        this.runtime.executeCommand(input);
    }

    public void print(String msg, boolean paging) {
        this.shell.write(msg, paging);
    }

    public void println(String msg, boolean paging) {
        this.shell.writeln(msg, paging);
    }

    public Executor<? extends CommandInvocation> buildExecutor(String line) throws CommandNotFoundException, CommandLineParserException, OptionValidatorException, CommandValidatorException, IOException {
        return this.runtime.buildExecutor(line);
    }

    public CommandInvocationConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public String inputLine(Prompt prompt, Completion completer) throws InterruptedException, IOException {
        if (this.console != null) {
            return this.console.readLine(prompt, completer);
        }
        return null;
    }
}

