/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.EscapeCharacterState;
import org.jboss.as.cli.parsing.GlobalCharacterHandlers;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;
import org.jboss.as.cli.parsing.QuotesState;

public class SegmentParsingInitialState
extends DefaultParsingState {
    public static SegmentParsingInitialState INSTANCE = new SegmentParsingInitialState();

    public SegmentParsingInitialState() {
        super("SEGMENT");
        LeadingWhitespaceState leadingWhitespaceState = new LeadingWhitespaceState();
        this.setEnterHandler(ctx -> {
            if (Character.isWhitespace(ctx.getCharacter())) {
                ctx.enterState(leadingWhitespaceState);
            }
        });
        this.setDefaultHandler(GlobalCharacterHandlers.CONTENT_CHARACTER_HANDLER);
        this.enterState('\"', QuotesState.QUOTES_EXCLUDED);
        this.enterState('\\', EscapeCharacterState.INSTANCE);
    }

    public static class SegmentParsingCallbackHandler
    implements ParsingStateCallbackHandler {
        private int offset = 0;
        private int unescapedInQuotes = 0;
        private int escapedInQuotes = 0;
        private int escapedOutsideQuotes = 0;
        private boolean openQuotes = false;

        @Override
        public void enteredState(ParsingContext ctx) throws CommandFormatException {
            if ("QUOTES".equals(ctx.getState().getId())) {
                ++this.offset;
                this.openQuotes = true;
            }
        }

        @Override
        public void leavingState(ParsingContext ctx) throws CommandFormatException {
            if ("QUOTES".equals(ctx.getState().getId()) && !ctx.isEndOfContent()) {
                ++this.offset;
                this.openQuotes = false;
            }
        }

        @Override
        public void character(ParsingContext ctx) throws CommandFormatException {
            char ch = ctx.getCharacter();
            if ("LEADING_WS".equals(ctx.getState().getId())) {
                ++this.offset;
            } else if ("ESCAPED_CHARACTER".equals(ctx.getState().getId())) {
                if (this.openQuotes && OperationRequestCompleter.ESCAPE_SELECTOR.isEscape(ch) && !OperationRequestCompleter.ESCAPE_SELECTOR_INSIDE_QUOTES.isEscape(ch)) {
                    ++this.escapedInQuotes;
                } else if (!this.openQuotes && OperationRequestCompleter.ESCAPE_SELECTOR.isEscape(ch) && !OperationRequestCompleter.ESCAPE_SELECTOR_INSIDE_QUOTES.isEscape(ch)) {
                    ++this.escapedOutsideQuotes;
                }
            } else if ("QUOTES".equals(ctx.getState().getId()) && OperationRequestCompleter.ESCAPE_SELECTOR.isEscape(ch) && !OperationRequestCompleter.ESCAPE_SELECTOR_INSIDE_QUOTES.isEscape(ch)) {
                ++this.unescapedInQuotes;
            }
        }

        public int getOffset() {
            if (this.openQuotes) {
                return this.offset + this.escapedInQuotes + this.escapedOutsideQuotes;
            }
            return this.offset - this.unescapedInQuotes;
        }

        public boolean isOpenQuotes() {
            return this.openQuotes;
        }

        public void reset() {
            this.offset = 0;
            this.unescapedInQuotes = 0;
            this.escapedInQuotes = 0;
            this.escapedOutsideQuotes = 0;
            this.openQuotes = false;
        }
    }

    private static class LeadingWhitespaceState
    extends DefaultParsingState {
        public static final String ID = "LEADING_WS";

        LeadingWhitespaceState() {
            super(ID);
            this.setDefaultHandler(ctx -> {
                if (!Character.isWhitespace(ctx.getCharacter())) {
                    ctx.leaveState();
                    ctx.resolveExpression(true, true);
                    ctx.getState().getHandler(ctx.getCharacter()).handle(ctx);
                } else {
                    ctx.getCallbackHandler().character(ctx);
                }
            });
        }
    }
}

