/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.util;

import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.jboss.vfs.VFSLogger;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;

public class IncludeExcludeVisitorAttributes
extends VisitorAttributes
implements VirtualFileFilter {
    private Set<String> includes;
    private Set<String> excludes;

    public IncludeExcludeVisitorAttributes(Set<String> includes, Set<String> excludes) {
        if (includes == null) {
            includes = Collections.emptySet();
        }
        if (excludes == null) {
            excludes = Collections.emptySet();
        }
        this.includes = includes;
        this.excludes = excludes;
        this.setIncludeRoot(false);
        this.setLeavesOnly(true);
        this.setRecurseFilter(this);
    }

    @Override
    public boolean accepts(VirtualFile file) {
        try {
            URL url = file.toURL();
            String urlString = url.toExternalForm();
            for (String include : this.includes) {
                if (urlString.contains(include)) continue;
                return false;
            }
            for (String exclude : this.excludes) {
                if (!urlString.contains(exclude)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            VFSLogger.ROOT_LOGGER.tracef((Throwable)e, "Exception while filtering file: %s", (Object)file);
            return false;
        }
    }
}

