/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.TopOrdAndIntQueue;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.TaxonomyFacets;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;

public abstract class IntTaxonomyFacets
extends TaxonomyFacets {
    protected final int[] values;

    protected IntTaxonomyFacets(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config) throws IOException {
        super(indexFieldName, taxoReader, config);
        this.values = new int[taxoReader.getSize()];
    }

    protected void rollup() throws IOException {
        for (Map.Entry<String, FacetsConfig.DimConfig> ent : this.config.getDimConfigs().entrySet()) {
            int dimRootOrd;
            String dim = ent.getKey();
            FacetsConfig.DimConfig ft = ent.getValue();
            if (!ft.hierarchical || ft.multiValued || (dimRootOrd = this.taxoReader.getOrdinal(new FacetLabel(dim))) <= 0) continue;
            int n = dimRootOrd;
            this.values[n] = this.values[n] + this.rollup(this.children[dimRootOrd]);
        }
    }

    private int rollup(int ord) {
        int sum = 0;
        while (ord != -1) {
            int childValue;
            this.values[ord] = childValue = this.values[ord] + this.rollup(this.children[ord]);
            sum += childValue;
            ord = this.siblings[ord];
        }
        return sum;
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        FacetsConfig.DimConfig dimConfig = this.verifyDim(dim);
        if (!(path.length != 0 || dimConfig.hierarchical && !dimConfig.multiValued || dimConfig.requireDimCount && dimConfig.multiValued)) {
            throw new IllegalArgumentException("cannot return dimension-level value alone; use getTopChildren instead");
        }
        int ord = this.taxoReader.getOrdinal(new FacetLabel(dim, path));
        if (ord < 0) {
            return -1;
        }
        return this.values[ord];
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        if (topN <= 0) {
            throw new IllegalArgumentException("topN must be > 0 (got: " + topN + ")");
        }
        FacetsConfig.DimConfig dimConfig = this.verifyDim(dim);
        FacetLabel cp = new FacetLabel(dim, path);
        int dimOrd = this.taxoReader.getOrdinal(cp);
        if (dimOrd == -1) {
            return null;
        }
        TopOrdAndIntQueue q = new TopOrdAndIntQueue(Math.min(this.taxoReader.getSize(), topN));
        int bottomValue = 0;
        int ord = this.children[dimOrd];
        int totValue = 0;
        int childCount = 0;
        TopOrdAndIntQueue.OrdAndValue reuse = null;
        while (ord != -1) {
            if (this.values[ord] > 0) {
                totValue += this.values[ord];
                ++childCount;
                if (this.values[ord] > bottomValue) {
                    if (reuse == null) {
                        reuse = new TopOrdAndIntQueue.OrdAndValue();
                    }
                    reuse.ord = ord;
                    reuse.value = this.values[ord];
                    reuse = (TopOrdAndIntQueue.OrdAndValue)q.insertWithOverflow(reuse);
                    if (q.size() == topN) {
                        bottomValue = ((TopOrdAndIntQueue.OrdAndValue)q.top()).value;
                    }
                }
            }
            ord = this.siblings[ord];
        }
        if (totValue == 0) {
            return null;
        }
        if (dimConfig.multiValued) {
            totValue = dimConfig.requireDimCount ? this.values[dimOrd] : -1;
        }
        LabelAndValue[] labelValues = new LabelAndValue[q.size()];
        for (int i = labelValues.length - 1; i >= 0; --i) {
            TopOrdAndIntQueue.OrdAndValue ordAndValue = (TopOrdAndIntQueue.OrdAndValue)q.pop();
            FacetLabel child = this.taxoReader.getPath(ordAndValue.ord);
            labelValues[i] = new LabelAndValue(child.components[cp.length], ordAndValue.value);
        }
        return new FacetResult(dim, path, totValue, labelValues, childCount);
    }
}

