/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;

public class PropertiesSaslClientFactory
extends AbstractDelegatingSaslClientFactory {
    private final Map<String, ?> properties;

    public PropertiesSaslClientFactory(SaslClientFactory delegate, Map<String, ?> properties) {
        super(delegate);
        this.properties = new HashMap(properties);
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return this.delegate.getMechanismNames(PropertiesSaslClientFactory.combine(props, this.properties));
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        return super.createSaslClient(mechanisms, authorizationId, protocol, serverName, PropertiesSaslClientFactory.combine(props, this.properties), cbh);
    }

    private static Map<String, ?> combine(Map<String, ?> provided, Map<String, ?> configured) {
        HashMap combined = new HashMap(provided);
        combined.putAll(configured);
        return combined;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof PropertiesSaslClientFactory && this.equals((PropertiesSaslClientFactory)other);
    }

    @Override
    public boolean equals(AbstractDelegatingSaslClientFactory other) {
        return other instanceof PropertiesSaslClientFactory && this.equals((PropertiesSaslClientFactory)other);
    }

    public boolean equals(PropertiesSaslClientFactory other) {
        return super.equals(other) && this.properties.equals(other.properties);
    }

    @Override
    protected int calculateHashCode() {
        return HashMath.multiHashOrdered(HashMath.multiHashOrdered(super.calculateHashCode(), this.getClass().hashCode()), this.properties.hashCode());
    }
}

