/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import javax.resource.spi.ConnectionRequestInfo;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRAProperties;
import org.apache.activemq.artemis.ra.ActiveMQRaUtils;

public class ActiveMQRAConnectionRequestInfo
implements ConnectionRequestInfo {
    private static boolean trace = ActiveMQRALogger.LOGGER.isTraceEnabled();
    private String userName;
    private String password;
    private String clientID;
    private final int type;
    private final boolean transacted;
    private final int acknowledgeMode;

    public ActiveMQRAConnectionRequestInfo(ActiveMQRAProperties prop, int type) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("constructor(" + prop + ")");
        }
        this.userName = prop.getUserName();
        this.password = prop.getPassword();
        this.clientID = prop.getClientID();
        this.type = type;
        this.transacted = true;
        this.acknowledgeMode = 1;
    }

    public ActiveMQRAConnectionRequestInfo(boolean transacted, int acknowledgeMode, int type) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("constructor(" + transacted + ", " + acknowledgeMode + ", " + type + ")");
        }
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.type = type;
    }

    public void setDefaults(ActiveMQRAProperties prop) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setDefaults(" + prop + ")");
        }
        if (this.userName == null) {
            this.userName = prop.getUserName();
        }
        if (this.password == null) {
            this.password = prop.getPassword();
        }
        if (this.clientID == null) {
            this.clientID = prop.getClientID();
        }
    }

    public String getUserName() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getUserName()");
        }
        return this.userName;
    }

    public void setUserName(String userName) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setUserName(" + userName + ")");
        }
        this.userName = userName;
    }

    public String getPassword() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getPassword()");
        }
        return this.password;
    }

    public void setPassword(String password) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setPassword(****)");
        }
        this.password = password;
    }

    public String getClientID() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getClientID()");
        }
        return this.clientID;
    }

    public void setClientID(String clientID) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setClientID(" + clientID + ")");
        }
        this.clientID = clientID;
    }

    public int getType() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getType()");
        }
        return this.type;
    }

    public boolean isTransacted() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("isTransacted() " + this.transacted);
        }
        return this.transacted;
    }

    public int getAcknowledgeMode() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getAcknowledgeMode()");
        }
        return this.acknowledgeMode;
    }

    public boolean equals(Object obj) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("equals(" + obj + ")");
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ActiveMQRAConnectionRequestInfo) {
            ActiveMQRAConnectionRequestInfo you = (ActiveMQRAConnectionRequestInfo)obj;
            return ActiveMQRaUtils.compare(this.userName, you.getUserName()) && ActiveMQRaUtils.compare(this.password, you.getPassword()) && ActiveMQRaUtils.compare(this.clientID, you.getClientID()) && this.type == you.getType() && this.transacted == you.isTransacted() && this.acknowledgeMode == you.getAcknowledgeMode();
        }
        return false;
    }

    public int hashCode() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("hashCode()");
        }
        int hash = 7;
        hash += 31 * hash + (this.userName != null ? this.userName.hashCode() : 0);
        hash += 31 * hash + (this.password != null ? this.password.hashCode() : 0);
        hash += 31 * hash + Integer.valueOf(this.type).hashCode();
        hash += 31 * hash + (this.transacted ? 1 : 0);
        hash += 31 * hash + Integer.valueOf(this.acknowledgeMode).hashCode();
        return hash;
    }

    public String toString() {
        return "ActiveMQRAConnectionRequestInfo[type=" + this.type + ", transacted=" + this.transacted + ", acknowledgeMode=" + this.acknowledgeMode + ", clientID=" + this.clientID + ", userName=" + this.userName + ", password=****]";
    }
}

