/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.security.PrivilegedAction;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.commons.CacheException;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.remoting.transport.Address;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.NodeAffinity;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherException;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Invoker;
import org.wildfly.clustering.ee.infinispan.CacheProperties;
import org.wildfly.clustering.ee.infinispan.InfinispanBatcher;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.ee.retry.RetryingInvoker;
import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.BeanManager;
import org.wildfly.clustering.ejb.IdentifierFactory;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.Time;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanExpirationScheduler;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroupFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroupKey;
import org.wildfly.clustering.ejb.infinispan.BeanKey;
import org.wildfly.clustering.ejb.infinispan.CancelSchedulerCommand;
import org.wildfly.clustering.ejb.infinispan.Configuration;
import org.wildfly.clustering.ejb.infinispan.ExpirationConfiguration;
import org.wildfly.clustering.ejb.infinispan.ExpiredBeanRemover;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerConfiguration;
import org.wildfly.clustering.ejb.infinispan.Key;
import org.wildfly.clustering.ejb.infinispan.PassivationConfiguration;
import org.wildfly.clustering.ejb.infinispan.ScheduleSchedulerCommand;
import org.wildfly.clustering.ejb.infinispan.Scheduler;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.spi.PredicateCacheEventFilter;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.spi.distribution.CacheLocality;
import org.wildfly.clustering.infinispan.spi.distribution.ConsistentHashLocality;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;
import org.wildfly.clustering.infinispan.spi.distribution.SimpleLocality;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.spi.NodeFactory;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener(primaryOnly=true)
public class InfinispanBeanManager<I, T>
implements BeanManager<I, T, TransactionBatch> {
    private static final Invoker INVOKER = new RetryingInvoker(new Duration[]{Duration.ZERO, Duration.ofMillis(10L), Duration.ofMillis(100L)});
    private final Cache<BeanKey<I>, BeanEntry<I>> cache;
    private final CacheProperties properties;
    private final BeanFactory<I, T> beanFactory;
    private final BeanGroupFactory<I, T> groupFactory;
    private final IdentifierFactory<I> identifierFactory;
    private final KeyAffinityService<BeanKey<I>> affinity;
    private final Registry<String, ?> registry;
    private final NodeFactory<Address> nodeFactory;
    private final CommandDispatcherFactory dispatcherFactory;
    private final ExpirationConfiguration<T> expiration;
    private final PassivationConfiguration<T> passivation;
    private final Batcher<TransactionBatch> batcher;
    private final Predicate<Map.Entry<? super BeanKey<I>, ? super BeanEntry<I>>> filter;
    private final AtomicReference<Future<?>> rehashFuture = new AtomicReference();
    private volatile Scheduler<I> scheduler;
    private volatile ExecutorService executor;
    private volatile CommandDispatcher<Scheduler<I>> dispatcher;

    private static ThreadFactory createThreadFactory() {
        PrivilegedAction<ThreadFactory> action = () -> new JBossThreadFactory(new ThreadGroup(InfinispanBeanManager.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null);
        return (ThreadFactory)WildFlySecurityManager.doUnchecked(action);
    }

    public InfinispanBeanManager(InfinispanBeanManagerConfiguration<I, T> configuration, IdentifierFactory<I> identifierFactory, Configuration<BeanKey<I>, BeanEntry<I>, BeanFactory<I, T>> beanConfiguration, Configuration<BeanGroupKey<I>, BeanGroupEntry<I, T>, BeanGroupFactory<I, T>> groupConfiguration) {
        this.filter = configuration.getBeanFilter();
        this.groupFactory = groupConfiguration.getFactory();
        this.beanFactory = beanConfiguration.getFactory();
        this.cache = beanConfiguration.getCache();
        this.properties = configuration.getProperties();
        this.batcher = new InfinispanBatcher(this.cache);
        Address address = this.cache.getCacheManager().getAddress();
        KeyAffinityServiceFactory affinityFactory = configuration.getAffinityFactory();
        KeyGenerator beanKeyGenerator = () -> ((BeanFactory)beanConfiguration.getFactory()).createKey(identifierFactory.createIdentifier());
        this.affinity = affinityFactory.createService(this.cache, beanKeyGenerator);
        this.identifierFactory = () -> ((BeanKey)this.affinity.getKeyForAddress(address)).getId();
        this.registry = configuration.getRegistry();
        this.nodeFactory = configuration.getNodeFactory();
        this.dispatcherFactory = configuration.getCommandDispatcherFactory();
        this.expiration = configuration.getExpirationConfiguration();
        this.passivation = configuration.getPassivationConfiguration();
    }

    public void start() {
        this.executor = Executors.newSingleThreadExecutor(InfinispanBeanManager.createThreadFactory());
        this.affinity.start();
        Time timeout = this.expiration.getTimeout();
        this.scheduler = timeout != null && timeout.getValue() >= 0L ? new BeanExpirationScheduler(this.batcher, new ExpiredBeanRemover<I, T>(this.beanFactory), this.expiration) : new Scheduler<I>(){

            @Override
            public void schedule(I id) {
            }

            @Override
            public void cancel(I id) {
            }

            @Override
            public void cancel(Locality locality) {
            }

            @Override
            public void close() {
            }
        };
        this.dispatcher = this.dispatcherFactory.createCommandDispatcher((Object)this.filter.toString(), this.scheduler);
        this.cache.addListener((Object)this, (CacheEventFilter)new PredicateCacheEventFilter(this.filter), null);
        this.schedule((Locality)new SimpleLocality(false), (Locality)new CacheLocality(this.cache));
    }

    public void stop() {
        this.groupFactory.close();
        this.cache.removeListener((Object)this);
        PrivilegedAction<List> action = () -> this.executor.shutdownNow();
        WildFlySecurityManager.doUnchecked(action);
        try {
            this.executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.dispatcher.close();
            this.scheduler.close();
            this.affinity.stop();
        }
    }

    public boolean isRemotable(Throwable throwable) {
        return !(throwable instanceof CacheException);
    }

    public Affinity getStrictAffinity() {
        Group group = this.registry.getGroup();
        return this.cache.getCacheConfiguration().clustering().cacheMode().isClustered() ? new ClusterAffinity(group.getName()) : new NodeAffinity((String)this.registry.getEntry(group.getLocalMember()).getKey());
    }

    public Affinity getWeakAffinity(I id) {
        Node node;
        Map.Entry entry;
        if (this.cache.getCacheConfiguration().clustering().cacheMode().isClustered() && (entry = this.registry.getEntry(node = this.locatePrimaryOwner(id))) != null) {
            return new NodeAffinity((String)entry.getKey());
        }
        return Affinity.NONE;
    }

    private void cancel(Bean<I, T> bean) {
        try {
            this.executeOnPrimaryOwner(bean, new CancelSchedulerCommand<I>(bean));
        }
        catch (Exception e) {
            InfinispanEjbLogger.ROOT_LOGGER.failedToCancelBean(e, bean.getId());
        }
    }

    void schedule(Bean<I, T> bean) {
        try {
            this.executeOnPrimaryOwner(bean, new ScheduleSchedulerCommand<I>(bean));
        }
        catch (Exception e) {
            InfinispanEjbLogger.ROOT_LOGGER.failedToScheduleBean(e, bean.getId());
        }
    }

    private void executeOnPrimaryOwner(final Bean<I, T> bean, final Command<Void, Scheduler<I>> command) throws CommandDispatcherException {
        final CommandDispatcher<Scheduler<I>> dispatcher = this.dispatcher;
        ExceptionSupplier<CompletionStage<Void>, CommandDispatcherException> action = new ExceptionSupplier<CompletionStage<Void>, CommandDispatcherException>(){

            public CompletionStage<Void> get() throws CommandDispatcherException {
                Node node = InfinispanBeanManager.this.locatePrimaryOwner(bean.getId());
                return dispatcher.executeOnMember(command, node);
            }
        };
        ((CompletionStage)INVOKER.invoke((ExceptionSupplier)action)).toCompletableFuture().join();
    }

    Node locatePrimaryOwner(I id) {
        DistributionManager dist = this.cache.getAdvancedCache().getDistributionManager();
        Address address = dist != null && !this.cache.getCacheConfiguration().clustering().cacheMode().isScattered() ? dist.getCacheTopology().getDistribution(new Key<I>(id)).primary() : null;
        Node member = address != null ? this.nodeFactory.createNode(address) : null;
        return member != null ? member : this.registry.getGroup().getLocalMember();
    }

    public Bean<I, T> createBean(I id, I groupId, T bean) {
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Creating bean %s associated with group %s", id, groupId);
        BeanGroup<I, T> group = this.groupFactory.createGroup(groupId, (BeanGroupEntry)this.groupFactory.createValue(groupId, null));
        group.addBean(id, bean);
        group.releaseBean(id, this.properties.isPersistent() ? this.passivation.getPassivationListener() : null);
        return new SchedulableBean(this.beanFactory.createBean(id, (BeanEntry)this.beanFactory.createValue(id, groupId)));
    }

    public Bean<I, T> findBean(I id) {
        Bean<I, T> bean;
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Locating bean %s", id);
        BeanEntry entry = (BeanEntry)this.beanFactory.findValue(id);
        Bean<I, T> bean2 = bean = entry != null ? this.beanFactory.createBean(id, entry) : null;
        if (bean == null) {
            InfinispanEjbLogger.ROOT_LOGGER.debugf("Could not find bean %s", id);
            return null;
        }
        this.cancel(bean);
        return new SchedulableBean(bean);
    }

    public boolean containsBean(I id) {
        return this.cache.containsKey(this.beanFactory.createKey(id));
    }

    public IdentifierFactory<I> getIdentifierFactory() {
        return this.identifierFactory;
    }

    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    public int getActiveCount() {
        try (CacheStream entries = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD}).entrySet().stream();){
            int n = (int)entries.filter(this.filter).count();
            return n;
        }
    }

    public int getPassiveCount() {
        return this.groupFactory.getPassiveCount();
    }

    @DataRehashed
    public void dataRehashed(DataRehashedEvent<BeanKey<I>, BeanEntry<I>> event) {
        ConsistentHashLocality newLocality = new ConsistentHashLocality(event.getCache(), event.getConsistentHashAtEnd());
        if (event.isPre()) {
            Future future = this.rehashFuture.getAndSet(null);
            if (future != null) {
                future.cancel(true);
            }
            try {
                this.executor.submit(() -> this.lambda$dataRehashed$4((Locality)newLocality));
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        } else {
            ConsistentHashLocality oldLocality = new ConsistentHashLocality(event.getCache(), event.getConsistentHashAtStart());
            try {
                this.rehashFuture.set(this.executor.submit(() -> this.lambda$dataRehashed$5((Locality)oldLocality, (Locality)newLocality)));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    private void schedule(Locality oldLocality, Locality newLocality) {
        try (CacheStream stream = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD}).entrySet().stream().filter(this.filter);){
            Iterator entries = stream.iterator();
            while (entries.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    break;
                }
                Map.Entry entry = (Map.Entry)entries.next();
                BeanKey key = (BeanKey)entry.getKey();
                if (!this.filter.test(entry) || oldLocality.isLocal((Object)key) || !newLocality.isLocal((Object)key)) continue;
                this.scheduler.schedule(key.getId());
            }
        }
    }

    private /* synthetic */ void lambda$dataRehashed$5(Locality oldLocality, Locality newLocality) {
        this.schedule(oldLocality, newLocality);
    }

    private /* synthetic */ void lambda$dataRehashed$4(Locality newLocality) {
        this.scheduler.cancel(newLocality);
    }

    private class SchedulableBean
    implements Bean<I, T> {
        private final Bean<I, T> bean;

        SchedulableBean(Bean<I, T> bean) {
            this.bean = bean;
        }

        public I getId() {
            return this.bean.getId();
        }

        public I getGroupId() {
            return this.bean.getGroupId();
        }

        public void remove(RemoveListener<T> listener) {
            this.bean.remove(listener);
        }

        public boolean isExpired() {
            return this.bean.isExpired();
        }

        public boolean isValid() {
            return this.bean.isValid();
        }

        public T acquire() {
            return this.bean.acquire();
        }

        public boolean release() {
            return this.bean.release();
        }

        public void close() {
            this.bean.close();
            if (this.bean.isValid()) {
                InfinispanBeanManager.this.schedule(this.bean);
            }
        }
    }
}

