/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security;

import io.undertow.servlet.api.ThreadSetupHandler;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.security.mapping.MappingContext;
import org.jboss.security.mapping.MappingManager;
import org.jboss.security.mapping.MappingType;
import org.wildfly.extension.undertow.security.SecurityActions;
import org.wildfly.extension.undertow.security.UndertowSecurityAttachments;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SecurityContextThreadSetupAction
implements ThreadSetupHandler {
    private final String securityDomain;
    private final SecurityDomainContext securityDomainContext;
    private final Map<String, Set<String>> principleVsRoleMap;
    private static final PrivilegedAction<Object> TEAR_DOWN_PA = new PrivilegedAction<Object>(){

        @Override
        public Object run() {
            SecurityActions.clearSecurityContext();
            SecurityRolesAssociation.setSecurityRoles(null);
            return null;
        }
    };

    public SecurityContextThreadSetupAction(String securityDomain, SecurityDomainContext securityDomainContext, Map<String, Set<String>> principleVsRoleMap) {
        this.securityDomain = securityDomain;
        this.securityDomainContext = securityDomainContext;
        this.principleVsRoleMap = principleVsRoleMap;
    }

    public <T, C> ThreadSetupHandler.Action<T, C> create(ThreadSetupHandler.Action<T, C> action) {
        return (exchange, context) -> {
            SecurityContext sc = null;
            if (exchange != null) {
                sc = (SecurityContext)exchange.getAttachment(UndertowSecurityAttachments.SECURITY_CONTEXT_ATTACHMENT);
            }
            if (sc == null) {
                sc = SecurityActions.createSecurityContext(this.securityDomain);
                if (exchange != null) {
                    exchange.putAttachment(UndertowSecurityAttachments.SECURITY_CONTEXT_ATTACHMENT, (Object)sc);
                }
            }
            SecurityActions.setSecurityContextOnAssociation(sc);
            final MappingManager mappingManager = this.securityDomainContext.getMappingManager();
            if (mappingManager != null) {
                if (WildFlySecurityManager.isChecking()) {
                    WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            MappingContext mc = mappingManager.getMappingContext(MappingType.ROLE.name());
                            if (mc != null && mc.hasModules()) {
                                SecurityRolesAssociation.setSecurityRoles((Map)SecurityContextThreadSetupAction.this.principleVsRoleMap);
                            }
                            return null;
                        }
                    });
                } else {
                    MappingContext mc = mappingManager.getMappingContext(MappingType.ROLE.name());
                    if (mc != null && mc.hasModules()) {
                        SecurityRolesAssociation.setSecurityRoles(this.principleVsRoleMap);
                    }
                }
            }
            try {
                Object object = action.call(exchange, context);
                return object;
            }
            finally {
                if (WildFlySecurityManager.isChecking()) {
                    WildFlySecurityManager.doUnchecked(TEAR_DOWN_PA);
                } else {
                    SecurityActions.clearSecurityContext();
                    SecurityRolesAssociation.setSecurityRoles(null);
                }
            }
        };
    }
}

