/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import org.jboss.as.clustering.controller.Operation;
import org.jboss.as.clustering.controller.OperationExecutor;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modcluster.ModClusterServiceMBean;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.service.ActiveServiceSupplier;
import org.wildfly.extension.mod_cluster.ProxyConfigurationResourceDefinition;

public class ProxyOperationExecutor
implements OperationExecutor<ModClusterServiceMBean> {
    public static final SimpleAttributeDefinition HOST = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"host", (ModelType)ModelType.STRING, (boolean)false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setStorageRuntime()).build();
    public static final SimpleAttributeDefinition PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"port", (ModelType)ModelType.INT, (boolean)false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new IntRangeValidator(1, 65535, false, false))).setStorageRuntime()).build();
    static final SimpleAttributeDefinition VIRTUAL_HOST = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"virtualhost", (ModelType)ModelType.STRING, (boolean)false).addFlag(AttributeAccess.Flag.RESTART_ALL_SERVICES)).setStorageRuntime()).build();
    static final SimpleAttributeDefinition WAIT_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"waittime", (ModelType)ModelType.INT, (boolean)true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setStorageRuntime()).setDefaultValue(new ModelNode(10))).setMeasurementUnit(MeasurementUnit.SECONDS)).build();
    static final SimpleAttributeDefinition CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"context", (ModelType)ModelType.STRING, (boolean)false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setStorageRuntime()).build();
    static final String SESSION_DRAINING_COMPLETE = "session-draining-complete";

    public ModelNode execute(OperationContext context, ModelNode operation, Operation<ModClusterServiceMBean> executable) throws OperationFailedException {
        ServiceName serviceName = ProxyConfigurationResourceDefinition.Capability.SERVICE.getDefinition().getCapabilityServiceName(context.getCurrentAddress());
        ModClusterServiceMBean service = (ModClusterServiceMBean)new ActiveServiceSupplier(context.getServiceRegistry(true), serviceName).get();
        return service != null ? executable.execute((ExpressionResolver)context, operation, (Object)service) : null;
    }
}

