/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.distributable;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ejb3.cache.CacheFactoryBuilderService;
import org.jboss.as.ejb3.cache.Contextual;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.cache.distributable.DistributableCacheFactoryBuilder;
import org.jboss.as.ejb3.cache.distributable.DistributableCacheFactoryService;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ejb.BeanContext;
import org.wildfly.clustering.ejb.BeanManagerFactoryServiceConfiguratorConfiguration;
import org.wildfly.clustering.ejb.BeanManagerFactoryServiceConfiguratorFactory;
import org.wildfly.clustering.ejb.BeanManagerFactoryServiceConfiguratorFactoryProvider;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.SimpleServiceNameProvider;

public class DistributableCacheFactoryBuilderService<K, V extends Identifiable<K> & Contextual<Batch>>
extends SimpleServiceNameProvider
implements ServiceConfigurator,
DistributableCacheFactoryBuilder<K, V> {
    private final BeanManagerFactoryServiceConfiguratorFactory builder;
    private final BeanManagerFactoryServiceConfiguratorConfiguration config;

    public static ServiceName getServiceName(String name) {
        return CacheFactoryBuilderService.BASE_CACHE_FACTORY_SERVICE_NAME.append(new String[]{"distributable", name});
    }

    public DistributableCacheFactoryBuilderService(CapabilityServiceSupport support, String name, BeanManagerFactoryServiceConfiguratorConfiguration config) {
        this(support, name, DistributableCacheFactoryBuilderService.load(), config);
    }

    private static BeanManagerFactoryServiceConfiguratorFactoryProvider load() {
        Iterator<BeanManagerFactoryServiceConfiguratorFactoryProvider> iterator = ServiceLoader.load(BeanManagerFactoryServiceConfiguratorFactoryProvider.class, BeanManagerFactoryServiceConfiguratorFactoryProvider.class.getClassLoader()).iterator();
        if (iterator.hasNext()) {
            BeanManagerFactoryServiceConfiguratorFactoryProvider provider = iterator.next();
            return provider;
        }
        return null;
    }

    public DistributableCacheFactoryBuilderService(CapabilityServiceSupport support, String name, BeanManagerFactoryServiceConfiguratorFactoryProvider provider, BeanManagerFactoryServiceConfiguratorConfiguration config) {
        super(DistributableCacheFactoryBuilderService.getServiceName(name));
        this.config = config;
        this.builder = provider.getBeanManagerFactoryBuilder(support, name, config);
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer cacheFactoryBuilder = builder.provides(new ServiceName[]{this.getServiceName()});
        Service service = Service.newInstance((Consumer)cacheFactoryBuilder, (Object)this);
        return builder.setInstance(service);
    }

    @Override
    public BeanManagerFactoryServiceConfiguratorConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public void installDeploymentUnitDependencies(CapabilityServiceSupport support, ServiceTarget target, ServiceName deploymentUnitServiceName) {
        for (CapabilityServiceConfigurator configurator : this.builder.getDeploymentServiceConfigurators(deploymentUnitServiceName)) {
            configurator.configure(support).build(target).install();
        }
    }

    @Override
    public ServiceBuilder<?> build(ServiceTarget target, ServiceName serviceName, BeanContext context, StatefulTimeoutInfo statefulTimeout) {
        ServiceConfigurator configurator = this.builder.getBeanManagerFactoryServiceConfigurator(context);
        return new DistributableCacheFactoryService(serviceName, configurator).build(target);
    }

    @Override
    public boolean supportsPassivation() {
        return true;
    }
}

