/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import org.jboss.as.ee.component.BasicComponentCreateService;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ejb3.cache.CacheFactory;
import org.jboss.as.ejb3.cache.CacheFactoryBuilder;
import org.jboss.as.ejb3.cache.CacheFactoryBuilderService;
import org.jboss.as.ejb3.cache.CacheInfo;
import org.jboss.as.ejb3.component.DefaultAccessTimeoutService;
import org.jboss.as.ejb3.component.EJBComponentCreateServiceFactory;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentCreateService;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class StatefulComponentCreateServiceFactory
extends EJBComponentCreateServiceFactory {
    public BasicComponentCreateService constructService(final ComponentConfiguration configuration) {
        if (this.ejbJarConfiguration == null) {
            throw EjbLogger.ROOT_LOGGER.ejbJarConfigNotBeenSet(this, configuration.getComponentName());
        }
        configuration.getCreateDependencies().add(new DependencyConfigurator<StatefulSessionComponentCreateService>(){

            public void configureDependency(ServiceBuilder<?> serviceBuilder, StatefulSessionComponentCreateService componentCreateService) {
                serviceBuilder.addDependency(DefaultAccessTimeoutService.STATEFUL_SERVICE_NAME, DefaultAccessTimeoutService.class, componentCreateService.getDefaultAccessTimeoutInjector());
            }
        });
        configuration.getCreateDependencies().add(new DependencyConfigurator<StatefulSessionComponentCreateService>(){

            public void configureDependency(ServiceBuilder<?> builder, StatefulSessionComponentCreateService service) {
                builder.addDependency(this.getServiceName(service), CacheFactoryBuilder.class, service.getCacheFactoryBuilderInjector());
            }

            private ServiceName getServiceName(StatefulSessionComponentCreateService service) {
                if (!service.isPassivationCapable()) {
                    return CacheFactoryBuilderService.DEFAULT_PASSIVATION_DISABLED_CACHE_SERVICE_NAME;
                }
                CacheInfo cache = service.getCache();
                return cache != null ? CacheFactoryBuilderService.getServiceName(cache.getName()) : CacheFactoryBuilderService.DEFAULT_CACHE_SERVICE_NAME;
            }
        });
        final InjectedValue factory = new InjectedValue();
        configuration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>(){

            public void configureDependency(ServiceBuilder<?> builder, ComponentStartService service) {
                builder.addDependency(configuration.getComponentDescription().getServiceName().append(new String[]{"cache"}), CacheFactory.class, (Injector)factory);
            }
        });
        return new StatefulSessionComponentCreateService(configuration, this.ejbJarConfiguration, (Value<CacheFactory>)factory);
    }
}

