/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.weld.ContainerState;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.bootstrap.BeanDeploymentArchiveMapping;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.Singleton;
import org.jboss.weld.bootstrap.api.SingletonProvider;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;

public class Container {
    public static final String CONTEXT_ID_KEY = "WELD_CONTEXT_ID_KEY";
    private static Singleton<Container> instance;
    private static final AtomicReference<Environment> ENV_REFERENCE;
    private final String contextId;
    private final BeanManagerImpl deploymentManager;
    private final Map<String, BeanManagerImpl> managers;
    private final Map<BeanDeploymentArchive, BeanManagerImpl> beanDeploymentArchives;
    private final ServiceRegistry deploymentServices;
    private ContainerState state = ContainerState.STOPPED;

    public static Container instance() {
        return (Container)instance.get("STATIC_INSTANCE");
    }

    public static boolean available() {
        return Container.available("STATIC_INSTANCE");
    }

    public static Container instance(String contextId) {
        return (Container)instance.get(contextId);
    }

    public static Container instance(BeanManagerImpl manager) {
        return Container.instance(manager.getContextId());
    }

    public static Container instance(AnnotatedTypeIdentifier identifier) {
        return Container.instance(identifier.getContextId());
    }

    public static boolean available(String contextId) {
        return Container.isSet(contextId) && Container.instance(contextId).getState().isAvailable();
    }

    public static boolean isSet(String contextId) {
        return instance.isSet(contextId);
    }

    public static void initialize(BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices) {
        Container instance = new Container("STATIC_INSTANCE", deploymentManager, deploymentServices);
        Container.instance.set("STATIC_INSTANCE", (Object)instance);
    }

    public static void initialize(String contextId, BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices) {
        Container.initialize(contextId, deploymentManager, deploymentServices, null);
    }

    public static void initialize(String contextId, BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices, Environment environment) {
        Container instance = new Container(contextId, deploymentManager, deploymentServices, environment);
        Container.instance.set(contextId, (Object)instance);
    }

    public Container(String contextId, BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices) {
        this(contextId, deploymentManager, deploymentServices, null);
    }

    public Container(BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices) {
        this("STATIC_INSTANCE", deploymentManager, deploymentServices);
    }

    public Container(String contextId, BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices, Environment environment) {
        this.deploymentManager = deploymentManager;
        this.managers = new ConcurrentHashMap<String, BeanManagerImpl>();
        this.managers.put(deploymentManager.getId(), deploymentManager);
        this.beanDeploymentArchives = new ConcurrentHashMap<BeanDeploymentArchive, BeanManagerImpl>();
        this.deploymentServices = deploymentServices;
        this.contextId = contextId;
        ENV_REFERENCE.compareAndSet(null, environment);
    }

    public void cleanup() {
        this.managers.clear();
        for (BeanManagerImpl beanManager : this.beanDeploymentArchives.values()) {
            beanManager.cleanup();
        }
        this.beanDeploymentArchives.clear();
        this.deploymentServices.cleanup();
        this.deploymentManager.cleanup();
        instance.clear(this.contextId);
    }

    public BeanManagerImpl deploymentManager() {
        return this.deploymentManager;
    }

    public Map<BeanDeploymentArchive, BeanManagerImpl> beanDeploymentArchives() {
        return this.beanDeploymentArchives;
    }

    public BeanManagerImpl getBeanManager(String key) {
        return this.managers.get(key);
    }

    @Deprecated
    public BeanManagerImpl activityManager(String key) {
        return this.getBeanManager(key);
    }

    private String addBeanManager(BeanManagerImpl manager) {
        String id = manager.getId();
        if (manager.getId() == null) {
            throw BeanManagerLogger.LOG.nullBeanManagerId();
        }
        this.managers.put(id, manager);
        return id;
    }

    public ServiceRegistry services() {
        return this.deploymentServices;
    }

    public void putBeanDeployments(BeanDeploymentArchiveMapping bdaMapping) {
        for (Map.Entry entry : bdaMapping.getBdaToBeanManagerMap().entrySet()) {
            this.beanDeploymentArchives.put((BeanDeploymentArchive)entry.getKey(), (BeanManagerImpl)entry.getValue());
            this.addBeanManager((BeanManagerImpl)entry.getValue());
        }
    }

    public ContainerState getState() {
        return this.state;
    }

    public void setState(ContainerState state) {
        this.state = state;
    }

    public static Environment getEnvironment() {
        return ENV_REFERENCE.get();
    }

    static {
        ENV_REFERENCE = new AtomicReference<Object>(null);
        instance = SingletonProvider.instance().create(Container.class);
    }
}

