/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

public class ContentType {
    private final String type;
    private final int version;

    public ContentType(String type, int version) {
        this.type = type;
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }

    public String toString() {
        return this.type + ";version=" + this.version;
    }

    public static ContentType parse(String type) {
        if (type == null) {
            return null;
        }
        String[] parts = type.split(";");
        if (parts.length == 0) {
            return null;
        }
        int version = -1;
        for (int i = 1; i < parts.length; ++i) {
            if (!parts[i].startsWith("version=")) continue;
            version = Integer.parseInt(parts[i].substring("version=".length()));
            break;
        }
        return new ContentType(parts[0], version);
    }
}

