/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.as.connector.subsystems.datasources.ModifiableDataSource;
import org.jboss.msc.inject.ConcurrentMapInjector;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class DataSourceConfigService
implements Service<ModifiableDataSource> {
    public static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"data-source-config"});
    private final ConcurrentMap<String, String> connectionProperties = new ConcurrentHashMap<String, String>(0);
    private final ModifiableDataSource dataSourceConfig;

    public DataSourceConfigService(ModifiableDataSource dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
    }

    public synchronized void start(StartContext startContext) throws StartException {
        for (Map.Entry connectionProperty : this.connectionProperties.entrySet()) {
            this.dataSourceConfig.addConnectionProperty((String)connectionProperty.getKey(), (String)connectionProperty.getValue());
        }
    }

    public synchronized void stop(StopContext stopContext) {
    }

    public ModifiableDataSource getValue() throws IllegalStateException, IllegalArgumentException {
        return this.dataSourceConfig;
    }

    public Injector<String> getConnectionPropertyInjector(String key) {
        return new ConcurrentMapInjector(this.connectionProperties, (Object)key);
    }
}

