/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.microprofile.config.spi.Converter;

class ImplicitConverters {
    ImplicitConverters() {
    }

    static Converter getConverter(Class<?> clazz) {
        for (Converter converter : new Converter[]{ImplicitConverters.getConverterFromStaticMethod(clazz, "of", String.class), ImplicitConverters.getConverterFromStaticMethod(clazz, "valueOf", String.class), ImplicitConverters.getConverterFromConstructor(clazz, String.class), ImplicitConverters.getConverterFromStaticMethod(clazz, "parse", CharSequence.class), ImplicitConverters.getConverterFromConstructor(clazz, CharSequence.class), ImplicitConverters.getConverterFromStaticMethod(clazz, "valueOf", CharSequence.class), ImplicitConverters.getConverterFromStaticMethod(clazz, "parse", String.class)}) {
            if (converter == null) continue;
            return converter;
        }
        return null;
    }

    private static Converter getConverterFromConstructor(Class<?> clazz, Class<?> paramType) {
        try {
            Constructor<?> declaredConstructor = clazz.getDeclaredConstructor(paramType);
            if (!declaredConstructor.isAccessible()) {
                declaredConstructor.setAccessible(true);
            }
            return value -> {
                try {
                    return declaredConstructor.newInstance(value);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Converter getConverterFromStaticMethod(Class<?> clazz, String methodName, Class<?> paramType) {
        try {
            Method method = clazz.getMethod(methodName, paramType);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (Modifier.isStatic(method.getModifiers())) {
                return new StaticMethodConverter(method);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static class StaticMethodConverter<T>
    implements Converter<T>,
    Serializable {
        private transient Method method;

        StaticMethodConverter(Method method) {
            this.method = method;
        }

        public T convert(String value) {
            try {
                return (T)this.method.invoke(null, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            String clsName = in.readUTF();
            String methodName = in.readUTF();
            String paramTypeName = in.readUTF();
            Class<?> paramType = Class.forName(paramTypeName);
            Class<?> cls = Class.forName(clsName);
            try {
                this.method = cls.getMethod(methodName, paramType);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeUTF(this.method.getDeclaringClass().getName());
            out.writeUTF(this.method.getName());
            out.writeUTF(this.method.getParameters()[0].getType().getName());
        }
    }
}

