/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.EEClassIntrospector;
import org.jboss.as.ee.component.ViewService;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.value.InjectedValue;

public class ComponentRegistry {
    private static ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"ee", "ComponentRegistry"});
    private final Map<Class<?>, ComponentManagedReferenceFactory> componentsByClass = new ConcurrentHashMap();
    private final ServiceRegistry serviceRegistry;
    private final InjectedValue<EEClassIntrospector> classIntrospectorInjectedValue = new InjectedValue();

    public static ServiceName serviceName(DeploymentUnit deploymentUnit) {
        return deploymentUnit.getServiceName().append(SERVICE_NAME);
    }

    public ComponentRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void addComponent(ComponentConfiguration componentConfiguration) {
        if (componentConfiguration.getViews().size() < 2) {
            if (componentConfiguration.getViews().size() == 0) {
                this.componentsByClass.put(componentConfiguration.getComponentClass(), new ComponentManagedReferenceFactory(componentConfiguration.getComponentDescription().getStartServiceName(), null));
            } else {
                this.componentsByClass.put(componentConfiguration.getComponentClass(), new ComponentManagedReferenceFactory(componentConfiguration.getComponentDescription().getStartServiceName(), componentConfiguration.getViews().get(0).getViewServiceName()));
            }
        }
    }

    public ManagedReferenceFactory createInstanceFactory(Class<?> componentClass) {
        ManagedReferenceFactory factory = this.componentsByClass.get(componentClass);
        if (factory == null) {
            return ((EEClassIntrospector)this.classIntrospectorInjectedValue.getValue()).createFactory(componentClass);
        }
        return factory;
    }

    public ManagedReference createInstance(Object instance) {
        ComponentManagedReferenceFactory factory = this.componentsByClass.get(instance.getClass());
        if (factory == null) {
            return ((EEClassIntrospector)this.classIntrospectorInjectedValue.getValue()).createInstance(instance);
        }
        return factory.getReference(instance);
    }

    public InjectedValue<EEClassIntrospector> getClassIntrospectorInjectedValue() {
        return this.classIntrospectorInjectedValue;
    }

    public class ComponentManagedReferenceFactory
    implements ManagedReferenceFactory {
        private final ServiceName serviceName;
        private final ServiceName viewServiceName;
        private volatile ServiceController<Component> component;
        private volatile ServiceController<ViewService.View> view;

        private ComponentManagedReferenceFactory(ServiceName serviceName, ServiceName viewServiceName) {
            this.serviceName = serviceName;
            this.viewServiceName = viewServiceName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ManagedReference getReference() {
            ComponentManagedReferenceFactory componentManagedReferenceFactory;
            if (this.component == null) {
                componentManagedReferenceFactory = this;
                synchronized (componentManagedReferenceFactory) {
                    if (this.component == null) {
                        this.component = ComponentRegistry.this.serviceRegistry.getService(this.serviceName);
                    }
                }
            }
            if (this.view == null && this.viewServiceName != null) {
                componentManagedReferenceFactory = this;
                synchronized (componentManagedReferenceFactory) {
                    if (this.view == null) {
                        this.view = ComponentRegistry.this.serviceRegistry.getService(this.viewServiceName);
                    }
                }
            }
            if (this.component == null) {
                return null;
            }
            if (this.view == null) {
                return new ComponentManagedReference(((Component)this.component.getValue()).createInstance());
            }
            try {
                return ((ViewService.View)this.view.getValue()).createInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ManagedReference getReference(Object instance) {
            if (this.component == null) {
                ComponentManagedReferenceFactory componentManagedReferenceFactory = this;
                synchronized (componentManagedReferenceFactory) {
                    if (this.component == null) {
                        this.component = ComponentRegistry.this.serviceRegistry.getService(this.serviceName);
                    }
                }
            }
            if (this.component == null) {
                return null;
            }
            return new ComponentManagedReference(((Component)this.component.getValue()).createInstance(instance));
        }

        public ServiceName getServiceName() {
            return this.serviceName;
        }
    }

    private static class ComponentManagedReference
    implements ManagedReference {
        private final ComponentInstance instance;
        private boolean destroyed;

        ComponentManagedReference(ComponentInstance component) {
            this.instance = component;
        }

        public synchronized void release() {
            if (!this.destroyed) {
                this.instance.destroy();
                this.destroyed = true;
            }
        }

        public Object getInstance() {
            return this.instance.getInstance();
        }
    }
}

