/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.ee.component.AbstractComponentConfigurator;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.serialization.WriteReplaceInterface;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ProxyMetadataSource;
import org.jboss.invocation.proxy.ProxyConfiguration;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.invocation.proxy.reflection.ReflectionMetadataSource;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

class DefaultComponentViewConfigurator
extends AbstractComponentConfigurator
implements ComponentConfigurator {
    private static final AtomicInteger PROXY_ID = new AtomicInteger(0);

    DefaultComponentViewConfigurator() {
    }

    @Override
    public void configure(DeploymentPhaseContext context, final ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ProxyMetadataSource proxyReflectionIndex = (ProxyMetadataSource)deploymentUnit.getAttachment(Attachments.PROXY_REFLECTION_INDEX);
        for (ViewDescription view : description.getViews()) {
            ViewConfiguration viewConfiguration;
            Class viewClass;
            try {
                viewClass = module.getClassLoader().loadClass(view.getViewClassName());
            }
            catch (ClassNotFoundException e) {
                throw EeLogger.ROOT_LOGGER.cannotLoadViewClass(e, view.getViewClassName(), configuration);
            }
            ProxyConfiguration proxyConfiguration = new ProxyConfiguration();
            if (viewClass.getName().startsWith("java.")) {
                proxyConfiguration.setProxyName("org.jboss.proxy.java.lang." + viewClass.getSimpleName() + "$$$view" + PROXY_ID.incrementAndGet());
            } else {
                proxyConfiguration.setProxyName(viewClass.getName() + "$$$view" + PROXY_ID.incrementAndGet());
            }
            proxyConfiguration.setClassLoader((ClassLoader)module.getClassLoader());
            proxyConfiguration.setProtectionDomain(viewClass.getProtectionDomain());
            proxyConfiguration.setMetadataSource((ReflectionMetadataSource)proxyReflectionIndex);
            if (view.isSerializable()) {
                proxyConfiguration.addAdditionalInterface(Serializable.class);
                if (view.isUseWriteReplace()) {
                    proxyConfiguration.addAdditionalInterface(WriteReplaceInterface.class);
                }
            }
            if (viewClass.isInterface()) {
                proxyConfiguration.setSuperClass(Object.class);
                proxyConfiguration.addAdditionalInterface(viewClass);
                viewConfiguration = view.createViewConfiguration(viewClass, configuration, new ProxyFactory(proxyConfiguration));
            } else {
                proxyConfiguration.setSuperClass(viewClass);
                viewConfiguration = view.createViewConfiguration(viewClass, configuration, new ProxyFactory(proxyConfiguration));
            }
            for (ViewConfigurator configurator : view.getConfigurators()) {
                configurator.configure(context, configuration, view, viewConfiguration);
            }
            configuration.getViews().add(viewConfiguration);
        }
        configuration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>(){

            @Override
            public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) {
                for (ServiceName dependencyName : description.getDependencies()) {
                    serviceBuilder.addDependency(dependencyName);
                }
            }
        });
    }
}

