/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools.journal;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.text.DecimalFormat;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.tools.OptionalLocking;
import org.apache.activemq.artemis.cli.commands.util.SyncCalculation;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.server.JournalType;

@Command(name="perf-journal", description="Calculates the journal-buffer-timeout you should use with the current data folder")
public class PerfJournal
extends OptionalLocking {
    @Option(name={"--block-size"}, description="The block size for each write (default 4096)")
    public int size = 4096;
    @Option(name={"--writes"}, description="The number of writes to be performed (default 250)")
    public int writes = 250;
    @Option(name={"--tries"}, description="The number of tries for the test (default 5)")
    public int tries = 5;
    @Option(name={"--no-sync"}, description="Disable sync")
    public boolean nosyncs = false;
    @Option(name={"--sync"}, description="Enable syncs")
    public boolean syncs = false;
    @Option(name={"--journal-type"}, description="Journal Type to be used (default from broker.xml)")
    public String journalType = null;
    @Option(name={"--sync-writes"}, description="It will perform each write synchronously, like if you had a single producer")
    public boolean syncWrites = false;
    @Option(name={"--file"}, description="The file name to be used (default test.tmp)")
    public String fileName = "test.tmp";
    @Option(name={"--max-aio"}, description="libaio.maxAIO to be used (default: configuration::getJournalMaxIO_AIO()")
    public int maxAIO = 0;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        FileConfiguration fileConfiguration = this.getFileConfiguration();
        if (this.nosyncs) {
            fileConfiguration.setJournalDatasync(false);
        } else if (this.syncs) {
            fileConfiguration.setJournalDatasync(true);
        }
        if (this.journalType != null) {
            fileConfiguration.setJournalType(JournalType.getType((String)this.journalType));
        }
        System.out.println("");
        System.out.println("Auto tuning journal ...");
        System.out.println("Performing " + this.tries + " tests writing " + this.writes + " blocks of " + this.size + " on each test, sync=" + fileConfiguration.isJournalDatasync() + " with journalType = " + fileConfiguration.getJournalType());
        fileConfiguration.getJournalLocation().mkdirs();
        if (this.maxAIO <= 0) {
            this.maxAIO = fileConfiguration.getJournalMaxIO_AIO();
        }
        long time = SyncCalculation.syncTest(fileConfiguration.getJournalLocation(), this.size, this.writes, this.tries, this.verbose, fileConfiguration.isJournalDatasync(), this.syncWrites, this.fileName, this.maxAIO, fileConfiguration.getJournalType());
        long nanosecondsWait = SyncCalculation.toNanos(time, this.writes, this.verbose);
        double writesPerMillisecond = (double)this.writes / (double)time;
        String writesPerMillisecondStr = new DecimalFormat("###.##").format(writesPerMillisecond);
        context.out.println("Your system can execute " + writesPerMillisecondStr + " syncs per millisecond");
        context.out.println("Your journal-buffer-timeout should be:" + nanosecondsWait);
        context.out.println("You should use this following configuration:");
        context.out.println();
        context.out.println("<journal-buffer-timeout>" + nanosecondsWait + "</journal-buffer-timeout>");
        return null;
    }
}

