/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TimeZone;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.eclipse.yasson.internal.serializer.BigDecimalTypeDeserializer;
import org.eclipse.yasson.internal.serializer.BigDecimalTypeSerializer;
import org.eclipse.yasson.internal.serializer.BigIntegerTypeDeserializer;
import org.eclipse.yasson.internal.serializer.BigIntegerTypeSerializer;
import org.eclipse.yasson.internal.serializer.BooleanTypeDeserializer;
import org.eclipse.yasson.internal.serializer.BooleanTypeSerializer;
import org.eclipse.yasson.internal.serializer.ByteTypeDeserializer;
import org.eclipse.yasson.internal.serializer.ByteTypeSerializer;
import org.eclipse.yasson.internal.serializer.CalendarTypeDeserializer;
import org.eclipse.yasson.internal.serializer.CalendarTypeSerializer;
import org.eclipse.yasson.internal.serializer.CharacterTypeDeserializer;
import org.eclipse.yasson.internal.serializer.CharacterTypeSerializer;
import org.eclipse.yasson.internal.serializer.DateTypeDeserializer;
import org.eclipse.yasson.internal.serializer.DateTypeSerializer;
import org.eclipse.yasson.internal.serializer.DoubleTypeDeserializer;
import org.eclipse.yasson.internal.serializer.DoubleTypeSerializer;
import org.eclipse.yasson.internal.serializer.DurationTypeDeserializer;
import org.eclipse.yasson.internal.serializer.DurationTypeSerializer;
import org.eclipse.yasson.internal.serializer.EnumTypeDeserializer;
import org.eclipse.yasson.internal.serializer.EnumTypeSerializer;
import org.eclipse.yasson.internal.serializer.FloatTypeDeserializer;
import org.eclipse.yasson.internal.serializer.FloatTypeSerializer;
import org.eclipse.yasson.internal.serializer.InstantTypeDeserializer;
import org.eclipse.yasson.internal.serializer.InstantTypeSerializer;
import org.eclipse.yasson.internal.serializer.IntegerTypeDeserializer;
import org.eclipse.yasson.internal.serializer.IntegerTypeSerializer;
import org.eclipse.yasson.internal.serializer.JsonNumberTypeDeserializer;
import org.eclipse.yasson.internal.serializer.JsonStringTypeDeserializer;
import org.eclipse.yasson.internal.serializer.JsonValueDeserializer;
import org.eclipse.yasson.internal.serializer.JsonValueSerializer;
import org.eclipse.yasson.internal.serializer.LocalDateTimeTypeDeserializer;
import org.eclipse.yasson.internal.serializer.LocalDateTimeTypeSerializer;
import org.eclipse.yasson.internal.serializer.LocalDateTypeDeserializer;
import org.eclipse.yasson.internal.serializer.LocalDateTypeSerializer;
import org.eclipse.yasson.internal.serializer.LocalTimeTypeDeserializer;
import org.eclipse.yasson.internal.serializer.LocalTimeTypeSerializer;
import org.eclipse.yasson.internal.serializer.LongTypeDeserializer;
import org.eclipse.yasson.internal.serializer.LongTypeSerializer;
import org.eclipse.yasson.internal.serializer.NumberTypeDeserializer;
import org.eclipse.yasson.internal.serializer.NumberTypeSerializer;
import org.eclipse.yasson.internal.serializer.OffsetDateTimeTypeDeserializer;
import org.eclipse.yasson.internal.serializer.OffsetDateTimeTypeSerializer;
import org.eclipse.yasson.internal.serializer.OffsetTimeTypeDeserializer;
import org.eclipse.yasson.internal.serializer.OffsetTimeTypeSerializer;
import org.eclipse.yasson.internal.serializer.OptionalDoubleTypeDeserializer;
import org.eclipse.yasson.internal.serializer.OptionalDoubleTypeSerializer;
import org.eclipse.yasson.internal.serializer.OptionalIntTypeDeserializer;
import org.eclipse.yasson.internal.serializer.OptionalIntTypeSerializer;
import org.eclipse.yasson.internal.serializer.OptionalLongTypeDeserializer;
import org.eclipse.yasson.internal.serializer.OptionalLongTypeSerializer;
import org.eclipse.yasson.internal.serializer.PeriodTypeDeserializer;
import org.eclipse.yasson.internal.serializer.PeriodTypeSerializer;
import org.eclipse.yasson.internal.serializer.SerializerProviderWrapper;
import org.eclipse.yasson.internal.serializer.ShortTypeDeserializer;
import org.eclipse.yasson.internal.serializer.ShortTypeSerializer;
import org.eclipse.yasson.internal.serializer.StringTypeDeserializer;
import org.eclipse.yasson.internal.serializer.StringTypeSerializer;
import org.eclipse.yasson.internal.serializer.TimeZoneTypeDeserializer;
import org.eclipse.yasson.internal.serializer.TimeZoneTypeSerializer;
import org.eclipse.yasson.internal.serializer.URITypeDeserializer;
import org.eclipse.yasson.internal.serializer.URITypeSerializer;
import org.eclipse.yasson.internal.serializer.URLTypeDeserializer;
import org.eclipse.yasson.internal.serializer.URLTypeSerializer;
import org.eclipse.yasson.internal.serializer.ZoneIdTypeDeserializer;
import org.eclipse.yasson.internal.serializer.ZoneIdTypeSerializer;
import org.eclipse.yasson.internal.serializer.ZoneOffsetTypeDeserializer;
import org.eclipse.yasson.internal.serializer.ZoneOffsetTypeSerializer;
import org.eclipse.yasson.internal.serializer.ZonedDateTimeTypeDeserializer;
import org.eclipse.yasson.internal.serializer.ZonedDateTimeTypeSerializer;

public class DefaultSerializers {
    private static final DefaultSerializers instance = new DefaultSerializers();
    private final Map<Class<?>, SerializerProviderWrapper> serializers = this.initSerializers();
    private final SerializerProviderWrapper enumProvider = new SerializerProviderWrapper(EnumTypeSerializer::new, EnumTypeDeserializer::new);

    private DefaultSerializers() {
    }

    private Map<Class<?>, SerializerProviderWrapper> initSerializers() {
        HashMap<Class<Object>, SerializerProviderWrapper> serializers = new HashMap<Class<Object>, SerializerProviderWrapper>();
        serializers.put(Boolean.class, new SerializerProviderWrapper(BooleanTypeSerializer::new, BooleanTypeDeserializer::new));
        serializers.put(Boolean.TYPE, new SerializerProviderWrapper(BooleanTypeSerializer::new, BooleanTypeDeserializer::new));
        serializers.put(Byte.class, new SerializerProviderWrapper(ByteTypeSerializer::new, ByteTypeDeserializer::new));
        serializers.put(Byte.TYPE, new SerializerProviderWrapper(ByteTypeSerializer::new, ByteTypeDeserializer::new));
        serializers.put(Calendar.class, new SerializerProviderWrapper(CalendarTypeSerializer::new, CalendarTypeDeserializer::new));
        serializers.put(GregorianCalendar.class, new SerializerProviderWrapper(CalendarTypeSerializer::new, CalendarTypeDeserializer::new));
        serializers.put(Character.class, new SerializerProviderWrapper(CharacterTypeSerializer::new, CharacterTypeDeserializer::new));
        serializers.put(Character.TYPE, new SerializerProviderWrapper(CharacterTypeSerializer::new, CharacterTypeDeserializer::new));
        serializers.put(Date.class, new SerializerProviderWrapper(DateTypeSerializer::new, DateTypeDeserializer::new));
        serializers.put(Double.class, new SerializerProviderWrapper(DoubleTypeSerializer::new, DoubleTypeDeserializer::new));
        serializers.put(Double.TYPE, new SerializerProviderWrapper(DoubleTypeSerializer::new, DoubleTypeDeserializer::new));
        serializers.put(Float.class, new SerializerProviderWrapper(FloatTypeSerializer::new, FloatTypeDeserializer::new));
        serializers.put(Float.TYPE, new SerializerProviderWrapper(FloatTypeSerializer::new, FloatTypeDeserializer::new));
        serializers.put(Instant.class, new SerializerProviderWrapper(InstantTypeSerializer::new, InstantTypeDeserializer::new));
        serializers.put(Integer.class, new SerializerProviderWrapper(IntegerTypeSerializer::new, IntegerTypeDeserializer::new));
        serializers.put(Integer.TYPE, new SerializerProviderWrapper(IntegerTypeSerializer::new, IntegerTypeDeserializer::new));
        serializers.put(JsonNumber.class, new SerializerProviderWrapper(JsonValueSerializer::new, JsonNumberTypeDeserializer::new));
        serializers.put(JsonString.class, new SerializerProviderWrapper(JsonValueSerializer::new, JsonStringTypeDeserializer::new));
        serializers.put(JsonValue.class, new SerializerProviderWrapper(JsonValueSerializer::new, JsonValueDeserializer::new));
        serializers.put(LocalDateTime.class, new SerializerProviderWrapper(LocalDateTimeTypeSerializer::new, LocalDateTimeTypeDeserializer::new));
        serializers.put(LocalDate.class, new SerializerProviderWrapper(LocalDateTypeSerializer::new, LocalDateTypeDeserializer::new));
        serializers.put(LocalTime.class, new SerializerProviderWrapper(LocalTimeTypeSerializer::new, LocalTimeTypeDeserializer::new));
        serializers.put(Long.class, new SerializerProviderWrapper(LongTypeSerializer::new, LongTypeDeserializer::new));
        serializers.put(Long.TYPE, new SerializerProviderWrapper(LongTypeSerializer::new, LongTypeDeserializer::new));
        serializers.put(Number.class, new SerializerProviderWrapper(NumberTypeSerializer::new, NumberTypeDeserializer::new));
        serializers.put(OffsetDateTime.class, new SerializerProviderWrapper(OffsetDateTimeTypeSerializer::new, OffsetDateTimeTypeDeserializer::new));
        serializers.put(OffsetTime.class, new SerializerProviderWrapper(OffsetTimeTypeSerializer::new, OffsetTimeTypeDeserializer::new));
        serializers.put(OptionalDouble.class, new SerializerProviderWrapper(OptionalDoubleTypeSerializer::new, OptionalDoubleTypeDeserializer::new));
        serializers.put(OptionalInt.class, new SerializerProviderWrapper(OptionalIntTypeSerializer::new, OptionalIntTypeDeserializer::new));
        serializers.put(OptionalLong.class, new SerializerProviderWrapper(OptionalLongTypeSerializer::new, OptionalLongTypeDeserializer::new));
        serializers.put(Short.class, new SerializerProviderWrapper(ShortTypeSerializer::new, ShortTypeDeserializer::new));
        serializers.put(Short.TYPE, new SerializerProviderWrapper(ShortTypeSerializer::new, ShortTypeDeserializer::new));
        serializers.put(String.class, new SerializerProviderWrapper(StringTypeSerializer::new, StringTypeDeserializer::new));
        serializers.put(TimeZone.class, new SerializerProviderWrapper(TimeZoneTypeSerializer::new, TimeZoneTypeDeserializer::new));
        serializers.put(URI.class, new SerializerProviderWrapper(URITypeSerializer::new, URITypeDeserializer::new));
        serializers.put(URL.class, new SerializerProviderWrapper(URLTypeSerializer::new, URLTypeDeserializer::new));
        serializers.put(ZonedDateTime.class, new SerializerProviderWrapper(ZonedDateTimeTypeSerializer::new, ZonedDateTimeTypeDeserializer::new));
        serializers.put(Duration.class, new SerializerProviderWrapper(DurationTypeSerializer::new, DurationTypeDeserializer::new));
        serializers.put(Period.class, new SerializerProviderWrapper(PeriodTypeSerializer::new, PeriodTypeDeserializer::new));
        serializers.put(ZoneId.class, new SerializerProviderWrapper(ZoneIdTypeSerializer::new, ZoneIdTypeDeserializer::new));
        serializers.put(BigInteger.class, new SerializerProviderWrapper(BigIntegerTypeSerializer::new, BigIntegerTypeDeserializer::new));
        serializers.put(BigDecimal.class, new SerializerProviderWrapper(BigDecimalTypeSerializer::new, BigDecimalTypeDeserializer::new));
        serializers.put(ZoneOffset.class, new SerializerProviderWrapper(ZoneOffsetTypeSerializer::new, ZoneOffsetTypeDeserializer::new));
        return Collections.unmodifiableMap(serializers);
    }

    public <T> Optional<SerializerProviderWrapper> findValueSerializerProvider(Class<T> clazz) {
        Class<T> candidate = clazz;
        do {
            SerializerProviderWrapper provider;
            if ((provider = this.serializers.get(candidate)) == null) continue;
            return Optional.of(provider);
        } while ((candidate = candidate.getSuperclass()) != null);
        return this.findByCondition(clazz);
    }

    private <T> Optional<SerializerProviderWrapper> findByCondition(Class<T> clazz) {
        if (Enum.class.isAssignableFrom(clazz)) {
            return Optional.of(this.enumProvider);
        }
        if (JsonString.class.isAssignableFrom(clazz)) {
            return Optional.of(this.serializers.get(JsonString.class));
        }
        if (JsonNumber.class.isAssignableFrom(clazz)) {
            return Optional.of(this.serializers.get(JsonNumber.class));
        }
        if (JsonValue.class.isAssignableFrom(clazz) && !JsonObject.class.isAssignableFrom(clazz) && !JsonArray.class.isAssignableFrom(clazz)) {
            return Optional.of(this.serializers.get(JsonValue.class));
        }
        return Optional.empty();
    }

    public static DefaultSerializers getInstance() {
        return instance;
    }
}

