/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.utils;

import java.io.File;

public class OSUtils {
    public static final boolean IS_LINUX;
    public static final boolean IS_WINDOWS;
    public static final boolean IS_CYGWIN;
    public static final boolean IS_OSX;
    public static final boolean IS_HPUX;
    public static final boolean IS_SUNOS;
    public static final String TTY_COMMAND;
    public static final String STTY_COMMAND;
    public static final String STTY_F_OPTION;
    public static final String INFOCMP_COMMAND;

    static {
        String infocmp;
        String sttyfopt;
        String stty;
        String tty;
        IS_LINUX = System.getProperty("os.name").toLowerCase().contains("linux");
        IS_WINDOWS = System.getProperty("os.name").toLowerCase().contains("win");
        IS_CYGWIN = IS_WINDOWS && System.getenv("PWD") != null && System.getenv("PWD").startsWith("/");
        IS_OSX = System.getProperty("os.name").toLowerCase().contains("mac");
        IS_HPUX = System.getProperty("os.name").toLowerCase().contains("hp-ux");
        IS_SUNOS = System.getProperty("os.name").toLowerCase().contains("sunos");
        if (IS_CYGWIN) {
            tty = "tty.exe";
            stty = "stty.exe";
            sttyfopt = null;
            infocmp = "infocmp.exe";
            String path = System.getenv("PATH");
            if (path != null) {
                String[] paths;
                for (String p : paths = path.split(";")) {
                    if (new File(p, "tty.exe").exists()) {
                        tty = new File(p, "tty.exe").getAbsolutePath();
                    }
                    if (new File(p, "stty.exe").exists()) {
                        stty = new File(p, "stty.exe").getAbsolutePath();
                    }
                    if (!new File(p, "infocmp.exe").exists()) continue;
                    infocmp = new File(p, "infocmp.exe").getAbsolutePath();
                }
            }
        } else {
            tty = "tty";
            stty = "stty";
            infocmp = "infocmp";
            sttyfopt = IS_OSX ? "-f" : (IS_HPUX || IS_SUNOS ? "" : "-F");
        }
        TTY_COMMAND = tty;
        STTY_COMMAND = stty;
        STTY_F_OPTION = sttyfopt;
        INFOCMP_COMMAND = infocmp;
    }
}

