/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.wildfly.common.context.Contextual;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.security.auth.client.AuthenticationContext;

class AuthenticationContextAssociationProcessor
implements DeploymentUnitProcessor {
    AuthenticationContextAssociationProcessor() {
    }

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        AuthenticationContext authenticationContext = (AuthenticationContext)context.getAttachment(ElytronExtension.AUTHENTICATION_CONTEXT_KEY);
        if (authenticationContext != null) {
            AuthenticationContext.getContextManager().setClassLoaderDefault((ClassLoader)((Module)context.getDeploymentUnit().getAttachment(Attachments.MODULE)).getClassLoader(), (Contextual)authenticationContext);
        }
    }

    public void undeploy(DeploymentUnit unit) {
        AuthenticationContext.getContextManager().setClassLoaderDefault((ClassLoader)((Module)unit.getAttachment(Attachments.MODULE)).getClassLoader(), null);
    }
}

