/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.security.AccessController;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.ContentRepositoryCleaner;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ContentCleanerService
implements Service<Void> {
    @Deprecated
    private static final String UNSUPPORTED_PROPERTY = "org.wildfly.unsupported.content.repository.obsolescence";
    public static final long DEFAULT_INTERVAL = System.getSecurityManager() == null ? Long.getLong("org.wildfly.unsupported.content.repository.obsolescence", 300000L).longValue() : AccessController.doPrivileged(() -> Long.getLong(UNSUPPORTED_PROPERTY, 300000L)).longValue();
    private static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"content-repository-cleaner"});
    private final InjectedValue<ModelControllerClientFactory> clientFactoryValue = new InjectedValue();
    private final InjectedValue<ScheduledExecutorService> scheduledExecutorValue = new InjectedValue();
    private final InjectedValue<ControlledProcessStateService> controlledProcessStateServiceValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executorServiceValue = new InjectedValue();
    private ContentRepositoryCleaner deploymentContentCleaner;
    private final long interval = DEFAULT_INTERVAL;
    private final boolean server;
    private final TimeUnit unit = TimeUnit.MILLISECONDS;

    public static void addService(ServiceTarget serviceTarget, ServiceName clientFactoryService, ServiceName scheduledExecutorServiceName) {
        ContentCleanerService service = new ContentCleanerService(true);
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME, (Service)service).addDependency(clientFactoryService, ModelControllerClientFactory.class, service.clientFactoryValue).addDependency(ControlledProcessStateService.SERVICE_NAME, ControlledProcessStateService.class, service.controlledProcessStateServiceValue).addDependency(scheduledExecutorServiceName, ScheduledExecutorService.class, service.scheduledExecutorValue);
        Services.addServerExecutorDependency(builder, service.executorServiceValue);
        builder.install();
    }

    public static void addServiceOnHostController(ServiceTarget serviceTarget, ServiceName hostControllerServiceName, ServiceName clientFactoryServiceName, ServiceName hostControllerExecutorServiceName, ServiceName scheduledExecutorServiceName) {
        ContentCleanerService service = new ContentCleanerService(false);
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME, (Service)service).addDependency(clientFactoryServiceName, ModelControllerClientFactory.class, service.clientFactoryValue).addDependency(ControlledProcessStateService.SERVICE_NAME, ControlledProcessStateService.class, service.controlledProcessStateServiceValue).addDependency(hostControllerExecutorServiceName, ExecutorService.class, service.executorServiceValue).addDependency(scheduledExecutorServiceName, ScheduledExecutorService.class, service.scheduledExecutorValue);
        builder.install();
    }

    ContentCleanerService(boolean server) {
        this.server = server;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.deploymentContentCleaner = new ContentRepositoryCleaner(((ModelControllerClientFactory)this.clientFactoryValue.getValue()).createSuperUserClient((Executor)this.executorServiceValue.getValue(), false), (ControlledProcessStateService)this.controlledProcessStateServiceValue.getValue(), (ScheduledExecutorService)this.scheduledExecutorValue.getValue(), this.unit.toMillis(this.interval), this.server);
        this.deploymentContentCleaner.startScan();
    }

    public synchronized void stop(StopContext context) {
        ContentRepositoryCleaner contentCleaner = this.deploymentContentCleaner;
        this.deploymentContentCleaner = null;
        contentCleaner.stopScan();
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }
}

