/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt;

import java.io.IOException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class ManagementWorkerService
implements Service<XnioWorker> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"serverManagement", "controller", "management", "worker"});
    private final OptionMap options;
    private XnioWorker worker;
    private volatile StopContext stopContext;

    private ManagementWorkerService(OptionMap options) {
        this.options = options;
    }

    public void start(StartContext startContext) throws StartException {
        Xnio xnio = Xnio.getInstance();
        try {
            this.worker = xnio.createWorker(null, this.options, this::stopDone);
        }
        catch (IOException e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        this.stopContext = context;
        context.asynchronous();
        this.worker.shutdown();
        this.worker = null;
    }

    private void stopDone() {
        StopContext stopContext = this.stopContext;
        this.stopContext = null;
        assert (stopContext != null);
        stopContext.complete();
    }

    public XnioWorker getValue() throws IllegalStateException, IllegalArgumentException {
        return this.worker;
    }

    public static void installService(ServiceTarget serviceTarget) {
        ManagementWorkerService service = new ManagementWorkerService(OptionMap.builder().set(Options.WORKER_IO_THREADS, 2).set(Options.WORKER_TASK_CORE_THREADS, 5).set(Options.WORKER_TASK_MAX_THREADS, 10).set(Options.TCP_NODELAY, true).set(Options.CORK, true).set(Options.WORKER_NAME, (Object)"management").getMap());
        serviceTarget.addService(SERVICE_NAME, (Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }
}

