/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.as.webservices.dmr.ListInjector;
import org.jboss.as.webservices.service.PropertyService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.config.AbstractCommonConfig;
import org.jboss.wsf.spi.metadata.config.ClientConfig;
import org.jboss.wsf.spi.metadata.config.EndpointConfig;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;

public final class ConfigService
implements Service<AbstractCommonConfig> {
    private final ServerConfig serverConfig;
    private final String configName;
    private final boolean client;
    private final List<UnifiedHandlerChainMetaData> preHandlerChains = new ArrayList<UnifiedHandlerChainMetaData>(1);
    private final List<UnifiedHandlerChainMetaData> postHandlerChains = new ArrayList<UnifiedHandlerChainMetaData>(1);
    private final List<PropertyService> properties = new ArrayList<PropertyService>(1);
    private volatile AbstractCommonConfig config;

    public ConfigService(ServerConfig serverConfig, String configName, boolean client) {
        this.configName = configName;
        this.client = client;
        this.serverConfig = serverConfig;
    }

    public AbstractCommonConfig getValue() {
        return this.config;
    }

    public void start(StartContext context) throws StartException {
        HashMap<String, String> props = null;
        if (!this.properties.isEmpty()) {
            props = new HashMap<String, String>(this.properties.size(), 1.0f);
            for (PropertyService ps : this.properties) {
                props.put(ps.getPropName(), ps.getPropValue());
            }
        }
        if (this.client) {
            ClientConfig clientConfig = new ClientConfig(this.configName, this.preHandlerChains, this.postHandlerChains, props, null);
            this.serverConfig.registerClientConfig(clientConfig);
            this.config = clientConfig;
        } else {
            EndpointConfig endpointConfig = new EndpointConfig(this.configName, this.preHandlerChains, this.postHandlerChains, props, null);
            this.serverConfig.registerEndpointConfig(endpointConfig);
            this.config = endpointConfig;
        }
    }

    public void stop(StopContext context) {
        if (this.client) {
            this.serverConfig.unregisterClientConfig((ClientConfig)this.config);
        } else {
            this.serverConfig.unregisterEndpointConfig((EndpointConfig)this.config);
        }
    }

    public Injector<UnifiedHandlerChainMetaData> getPreHandlerChainsInjector() {
        return new ListInjector<UnifiedHandlerChainMetaData>(this.preHandlerChains);
    }

    public Injector<UnifiedHandlerChainMetaData> getPostHandlerChainsInjector() {
        return new ListInjector<UnifiedHandlerChainMetaData>(this.postHandlerChains);
    }

    public Injector<PropertyService> getPropertiesInjector() {
        return new ListInjector<PropertyService>(this.properties);
    }
}

