/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.tomcat;

import java.util.List;
import java.util.Set;
import org.jboss.as.ee.structure.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.metadata.model.EJBEndpoint;
import org.jboss.as.webservices.tomcat.SecurityMetaDataAccessorEJB;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBSecurityMetaData;

abstract class AbstractSecurityMetaDataAccessorEJB
implements SecurityMetaDataAccessorEJB {
    AbstractSecurityMetaDataAccessorEJB() {
    }

    @Override
    public String getSecurityDomain(Deployment dep) {
        DeploymentUnit unit;
        String securityDomain = null;
        for (EJBEndpoint ejbEndpoint : this.getEjbEndpoints(dep)) {
            String nextSecurityDomain = ejbEndpoint.getSecurityDomain();
            if (nextSecurityDomain == null || nextSecurityDomain.isEmpty()) {
                nextSecurityDomain = null;
            }
            securityDomain = this.getDomain(securityDomain, nextSecurityDomain);
        }
        if (securityDomain == null && (unit = (DeploymentUnit)WSHelper.getRequiredAttachment((Deployment)dep, DeploymentUnit.class)).getParent() != null) {
            EarMetaData jbossAppMD = (EarMetaData)unit.getParent().getAttachment(Attachments.EAR_METADATA);
            return jbossAppMD instanceof JBossAppMetaData ? ((JBossAppMetaData)jbossAppMD).getSecurityDomain() : null;
        }
        return securityDomain;
    }

    @Override
    public SecurityRolesMetaData getSecurityRoles(Deployment dep) {
        SecurityRolesMetaData securityRolesMD = new SecurityRolesMetaData();
        Set<String> firstEndpointDeclaredSecurityRoles = null;
        for (EJBEndpoint ejbEndpoint : this.getEjbEndpoints(dep)) {
            Set<String> declaredSecurityRoles = ejbEndpoint.getDeclaredSecurityRoles();
            if (firstEndpointDeclaredSecurityRoles == null) {
                firstEndpointDeclaredSecurityRoles = declaredSecurityRoles;
            } else if (!firstEndpointDeclaredSecurityRoles.equals(declaredSecurityRoles)) {
                WSLogger.ROOT_LOGGER.multipleEndpointsWithDifferentDeclaredSecurityRoles();
            }
            for (String roleName : declaredSecurityRoles) {
                SecurityRoleMetaData securityRoleMD = new SecurityRoleMetaData();
                securityRoleMD.setRoleName(roleName);
                securityRolesMD.add((MappableMetaData)securityRoleMD);
            }
        }
        return securityRolesMD;
    }

    protected abstract List<EJBEndpoint> getEjbEndpoints(Deployment var1);

    @Override
    public String getAuthMethod(Endpoint endpoint) {
        EJBSecurityMetaData ejbSecurityMD = this.getEjbSecurityMetaData(endpoint);
        boolean hasEjbSecurityMD = ejbSecurityMD != null;
        return hasEjbSecurityMD ? ejbSecurityMD.getAuthMethod() : null;
    }

    @Override
    public boolean isSecureWsdlAccess(Endpoint endpoint) {
        EJBSecurityMetaData ejbSecurityMD = this.getEjbSecurityMetaData(endpoint);
        boolean hasEjbSecurityMD = ejbSecurityMD != null;
        return hasEjbSecurityMD ? ejbSecurityMD.getSecureWSDLAccess() : false;
    }

    @Override
    public String getTransportGuarantee(Endpoint endpoint) {
        EJBSecurityMetaData ejbSecurityMD = this.getEjbSecurityMetaData(endpoint);
        boolean hasEjbSecurityMD = ejbSecurityMD != null;
        return hasEjbSecurityMD ? ejbSecurityMD.getTransportGuarantee() : null;
    }

    @Override
    public String getRealmName(Endpoint endpoint) {
        EJBSecurityMetaData ejbSecurityMD = this.getEjbSecurityMetaData(endpoint);
        boolean hasEjbSecurityMD = ejbSecurityMD != null;
        return hasEjbSecurityMD ? ejbSecurityMD.getRealmName() : null;
    }

    private EJBSecurityMetaData getEjbSecurityMetaData(Endpoint endpoint) {
        String ejbName = endpoint.getShortName();
        Deployment dep = endpoint.getService().getDeployment();
        EJBArchiveMetaData ejbArchiveMD = (EJBArchiveMetaData)WSHelper.getOptionalAttachment((Deployment)dep, EJBArchiveMetaData.class);
        EJBMetaData ejbMD = ejbArchiveMD != null ? ejbArchiveMD.getBeanByEjbName(ejbName) : null;
        return ejbMD != null ? ejbMD.getSecurityMetaData() : null;
    }

    private String getDomain(String oldSecurityDomain, String nextSecurityDomain) {
        if (nextSecurityDomain == null) {
            return oldSecurityDomain;
        }
        if (oldSecurityDomain == null) {
            return nextSecurityDomain;
        }
        this.ensureSameDomains(oldSecurityDomain, nextSecurityDomain);
        return oldSecurityDomain;
    }

    private void ensureSameDomains(String oldSecurityDomain, String newSecurityDomain) {
        boolean domainsDiffer;
        boolean bl = domainsDiffer = !oldSecurityDomain.equals(newSecurityDomain);
        if (domainsDiffer) {
            throw WSLogger.ROOT_LOGGER.multipleSecurityDomainsDetected(oldSecurityDomain, newSecurityDomain);
        }
    }
}

