/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import org.hibernate.engine.spi.SessionImplementor;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.hibernate.cache.commons.access.BaseInvalidationInterceptor;
import org.infinispan.hibernate.cache.commons.access.InvalidationSynchronization;
import org.infinispan.hibernate.cache.commons.access.NonTxPutFromLoadInterceptor;
import org.infinispan.hibernate.cache.commons.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.commons.access.SessionAccess;
import org.infinispan.hibernate.cache.commons.access.SessionInvocationContext;
import org.infinispan.hibernate.cache.commons.util.CacheCommandInitializer;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.interceptors.InvocationFinallyFunction;
import org.infinispan.interceptors.impl.InvalidationInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="Invalidation", description="Component responsible for invalidating entries on remote caches when entries are written to locally.")
public class NonTxInvalidationInterceptor
extends BaseInvalidationInterceptor {
    private static final SessionAccess SESSION_ACCESS = SessionAccess.findSessionAccess();
    private final PutFromLoadValidator putFromLoadValidator;
    private final NonTxPutFromLoadInterceptor nonTxPutFromLoadInterceptor;
    @Inject
    private CacheCommandInitializer commandInitializer;
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(InvalidationInterceptor.class);
    private static final Log ispnLog = LogFactory.getLog(NonTxInvalidationInterceptor.class);

    public NonTxInvalidationInterceptor(PutFromLoadValidator putFromLoadValidator, NonTxPutFromLoadInterceptor nonTxPutFromLoadInterceptor) {
        this.putFromLoadValidator = putFromLoadValidator;
        this.nonTxPutFromLoadInterceptor = nonTxPutFromLoadInterceptor;
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (command.hasFlag(Flag.PUT_FOR_EXTERNAL_READ)) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        assert (ctx.isOriginLocal());
        boolean isTransactional = this.registerRemoteInvalidation((AbstractDataWriteCommand)command, (SessionInvocationContext)ctx);
        if (!isTransactional) {
            throw new IllegalStateException("Put executed without transaction!");
        }
        if (!this.putFromLoadValidator.beginInvalidatingWithPFER(command.getKeyLockOwner(), command.getKey(), command.getValue())) {
            log.failedInvalidatePendingPut(command.getKey(), this.cacheName);
        }
        RemoveCommand removeCommand = this.commandsFactory.buildRemoveCommand(command.getKey(), null, command.getSegment(), command.getFlagsBitSet());
        return this.invokeNextAndHandle(ctx, (VisitableCommand)removeCommand, new InvalidateAndReturnFunction(isTransactional, command.getKeyLockOwner()));
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        throw new UnsupportedOperationException("Unexpected replace");
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        boolean isTransactional = false;
        if (ctx instanceof SessionInvocationContext) {
            isTransactional = this.registerRemoteInvalidation((AbstractDataWriteCommand)command, (SessionInvocationContext)ctx);
            assert (isTransactional);
            if (!this.putFromLoadValidator.beginInvalidatingKey(command.getKeyLockOwner(), command.getKey())) {
                log.failedInvalidatePendingPut(command.getKey(), this.cacheName);
            }
        } else {
            log.trace("This is an eviction, not invalidating anything");
        }
        return this.invokeNextAndHandle(ctx, (VisitableCommand)command, new InvalidateAndReturnFunction(isTransactional, command.getKeyLockOwner()));
    }

    private boolean registerRemoteInvalidation(AbstractDataWriteCommand command, SessionInvocationContext sctx) {
        SessionAccess.TransactionCoordinatorAccess transactionCoordinator = SESSION_ACCESS.getTransactionCoordinator(sctx.getSession());
        if (transactionCoordinator != null) {
            if (this.trace) {
                log.tracef("Registering synchronization on transaction in %s, cache %s: %s", NonTxInvalidationInterceptor.lockOwnerToString(sctx.getSession()), this.cache.getName(), command.getKey());
            }
            InvalidationSynchronization sync = new InvalidationSynchronization(this.nonTxPutFromLoadInterceptor, command.getKey(), command.getKeyLockOwner());
            transactionCoordinator.registerLocalSynchronization(sync);
            return true;
        }
        return false;
    }

    private static String lockOwnerToString(Object lockOwner) {
        return lockOwner instanceof SessionImplementor ? "Session#" + lockOwner.hashCode() : lockOwner.toString();
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        Object retval = this.invokeNext(ctx, (VisitableCommand)command);
        if (!this.isLocalModeForced((FlagAffectedCommand)command) && ctx.isOriginLocal()) {
            this.rpcManager.invokeRemotely(this.getMembers(), (ReplicableCommand)command, this.isSynchronous((FlagAffectedCommand)command) ? this.syncRpcOptions : this.asyncRpcOptions);
        }
        return retval;
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        throw new UnsupportedOperationException("Unexpected putAll");
    }

    private <T extends WriteCommand & RemoteLockCommand> void invalidateAcrossCluster(T command, boolean isTransactional, Object key, Object keyLockOwner) throws Throwable {
        this.incrementInvalidations();
        if (!this.isLocalModeForced((FlagAffectedCommand)command)) {
            InvalidateCommand invalidateCommand = isTransactional ? this.commandInitializer.buildBeginInvalidationCommand(0L, new Object[]{key}, keyLockOwner) : this.commandsFactory.buildInvalidateCommand(0L, new Object[]{key});
            if (log.isDebugEnabled()) {
                log.debug("Cache [" + this.rpcManager.getAddress() + "] replicating " + invalidateCommand);
            }
            this.rpcManager.invokeRemotely(this.getMembers(), (ReplicableCommand)invalidateCommand, this.isSynchronous((FlagAffectedCommand)command) ? this.syncRpcOptions : this.asyncRpcOptions);
        }
    }

    protected Log getLog() {
        return ispnLog;
    }

    class InvalidateAndReturnFunction
    implements InvocationFinallyFunction {
        final boolean isTransactional;
        final Object keyLockOwner;

        InvalidateAndReturnFunction(boolean isTransactional, Object keyLockOwner) {
            this.isTransactional = isTransactional;
            this.keyLockOwner = keyLockOwner;
        }

        public Object apply(InvocationContext rCtx, VisitableCommand rCommand, Object rv, Throwable throwable) throws Throwable {
            RemoveCommand removeCmd = (RemoveCommand)rCommand;
            if (removeCmd.isSuccessful()) {
                NonTxInvalidationInterceptor.this.invalidateAcrossCluster((WriteCommand)removeCmd, this.isTransactional, removeCmd.getKey(), this.keyLockOwner);
            }
            return rv;
        }
    }
}

